﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Markup;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// GPIO管理器
    /// </summary>
    public static class GPIOManager
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(GPIOManager));

        /// <summary>
        /// 搜索设备
        /// </summary>
        /// <returns>设备个数</returns>
        public static List<USBDeviceInfo> ScanDevice()
        {
            List<USBDeviceInfo> infos = new List<USBDeviceInfo>();

            //扫描查找设备
            int[] devHandles = new int[20];
            int devNum = USBDevice.USB_ScanDevice(devHandles);

            if (devNum <= 0)
            {
                return infos;
            }

            for (int i = 0; i < devNum; ++i)
            {
                USBDeviceInfo info = new USBDeviceInfo();
                info.Handle = devHandles[i];

                infos.Add(info);
            }

            return infos;
        }

        /// <summary>
        /// 模型集合
        /// </summary>
        public static List<GPIOModel> Models { get; private set; } = new List<GPIOModel>();

        /// <summary>
        /// 获取引脚模型集合
        /// </summary>
        /// <returns>引脚模型集合</returns>
        public static List<GPIOPinModel> GetPinModels()
        {
            List<GPIOPinModel> models = new List<GPIOPinModel>();

            models.Add(new GPIOPinModel { Index = 0, PinMask = GPIOPin.PIN_0 });
            models.Add(new GPIOPinModel { Index = 1, PinMask = GPIOPin.PIN_1 });
            models.Add(new GPIOPinModel { Index = 2, PinMask = GPIOPin.PIN_2 });
            models.Add(new GPIOPinModel { Index = 3, PinMask = GPIOPin.PIN_3 });
            models.Add(new GPIOPinModel { Index = 4, PinMask = GPIOPin.PIN_4 });
            models.Add(new GPIOPinModel { Index = 5, PinMask = GPIOPin.PIN_5 });
            models.Add(new GPIOPinModel { Index = 6, PinMask = GPIOPin.PIN_6 });
            models.Add(new GPIOPinModel { Index = 7, PinMask = GPIOPin.PIN_7 });
            models.Add(new GPIOPinModel { Index = 8, PinMask = GPIOPin.PIN_8 });
            models.Add(new GPIOPinModel { Index = 9, PinMask = GPIOPin.PIN_9 });
            models.Add(new GPIOPinModel { Index = 10, PinMask = GPIOPin.PIN_10 });
            models.Add(new GPIOPinModel { Index = 11, PinMask = GPIOPin.PIN_11 });
            models.Add(new GPIOPinModel { Index = 12, PinMask = GPIOPin.PIN_12 });
            models.Add(new GPIOPinModel { Index = 13, PinMask = GPIOPin.PIN_13 });
            models.Add(new GPIOPinModel { Index = 14, PinMask = GPIOPin.PIN_14 });
            models.Add(new GPIOPinModel { Index = 15, PinMask = GPIOPin.PIN_15 });

            return models;
        }

        /// <summary>
        /// 获取引脚掩码
        /// </summary>
        /// <param name="index">引脚位序</param>
        /// <returns>引脚掩码</returns>
        public static uint GetPinMask(int? index)
        {
            if (index == null)
                return GPIOPin.PIN_DEFAULT_VALUE;

            switch (index.Value)
            {
                case 0: return GPIOPin.PIN_0;
                case 1: return GPIOPin.PIN_1;
                case 2: return GPIOPin.PIN_2;
                case 3: return GPIOPin.PIN_3;
                case 4: return GPIOPin.PIN_4;
                case 5: return GPIOPin.PIN_5;
                case 6: return GPIOPin.PIN_6;
                case 7: return GPIOPin.PIN_7;
                case 8: return GPIOPin.PIN_8;
                case 9: return GPIOPin.PIN_9;
                case 10: return GPIOPin.PIN_10;
                case 11: return GPIOPin.PIN_11;
                case 12: return GPIOPin.PIN_12;
                case 13: return GPIOPin.PIN_13;
                case 14: return GPIOPin.PIN_14;
                case 15: return GPIOPin.PIN_15;
                default: return GPIOPin.PIN_DEFAULT_VALUE;
            }
        }
    }
}
