﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// GPIO属性模型
    /// </summary>
    public class GPIOPropertyModel : ModelBase
    {
        #region PinValue -- 引脚值

        private bool pinValue;
        /// <summary>
        /// 引脚值
        /// </summary>
        public bool PinValue
        {
            get { return pinValue; }
            private set { pinValue = value; this.RaisePropertyChanged(nameof(PinValue)); }
        }

        #endregion

        #region PinMask -- 引脚掩码

        private uint pinMask;
        /// <summary>
        /// 引脚掩码
        /// <see cref="GPIOPin"/>
        /// </summary>
        public uint PinMask
        {
            get { return pinMask; }
            set { pinMask = value; this.RaisePropertyChanged(nameof(PinMask)); }
        }

        #endregion

        #region GPIOModel -- GPIO模型

        private GPIOModel gpioModel;
        /// <summary>
        /// GPIO模型
        /// </summary>
        public GPIOModel GPIOModel
        {
            get { return gpioModel; }
            set
            {
                if (gpioModel != null)
                {
                    gpioModel.PinValueChanged -= GpioModel_PinValueChanged;
                }

                gpioModel = value;
                this.RaisePropertyChanged(nameof(GPIOModel));

                if (gpioModel != null)
                {
                    gpioModel.PinValueChanged -= GpioModel_PinValueChanged;
                    gpioModel.PinValueChanged += GpioModel_PinValueChanged;
                }
            }
        }

        /// <summary>
        /// 引脚值发生改变时触发
        /// </summary>
        private void GpioModel_PinValueChanged(object sender, GPIOModelPinValueChangedEventArgs e)
        {
            this.PinValue = (this.PinMask & e.PinValue) == 0;
        }

        #endregion
    }
}
