﻿using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Management;
using VIZ.Framework.Core;
using VIZ.Framework.Connection;
using VIZ.Framework.Module;
using System.Reflection;
using VIZ.Framework.Domain;

namespace VIZ.Framework.Module
{
    /// <summary>
    /// 应用程序启动 -- 对象池
    /// </summary>
    public class AppSetup_ObjectPool : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_ObjectPool));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 对象池";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ApplicationDomain.ObjectPoolManager?.DisposeAll();
        }
    }
}
