﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Module;
using log4net;
using VIZ.Framework.Connection;

namespace VIZ.Framework.TimeSliceTool
{
    /// <summary>
    /// 应用程序启动 -- 初始化UDP
    /// </summary>
    public class AppSetup_InitUDP : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitUDP));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化UDP";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            UdpConnection conn = new UdpConnection();

            // -----------------------------------------------------------------
            // 客户端
            string clientIP = ApplicationDomainEx.IniStorage.GetValue<UdpConfig, string>(p => p.UDP_BINDING_IP);
            int clientPort = ApplicationDomainEx.IniStorage.GetValue<UdpConfig, int>(p => p.UDP_BINDING_PORT);
            conn.Binding(clientIP, clientPort);

            ConnectionManager.UdpConnection = conn;

            conn.Start();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ConnectionManager.UdpConnection?.Dispose();
        }
    }
}
