﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Connection
{
    /// <summary>
    /// 连接数据包信息
    /// </summary>
    public class ConnPackageInfo
    {
        /// <summary>
        /// 本地IP
        /// </summary>
        public string LocalIP { get; internal set; }

        /// <summary>
        /// 本地端口
        /// </summary>
        public int LocalPort { get; internal set; }

        /// <summary>
        /// 远程IP
        /// </summary>
        public string RemoteIP { get; internal set; }

        /// <summary>
        /// 远程端口
        /// </summary>
        public int RemotePort { get; internal set; }

        /// <summary>
        /// 串口名称
        /// </summary>
        public string PortName { get; internal set; }

        /// <summary>
        /// 数据
        /// </summary>
        public byte[] Data { get; set; }

        /// <summary>
        /// 数据大小
        /// </summary>
        public int DataSize { get; set; }
    }
}
