﻿using log4net;
using SharpDX.Direct2D1;
using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 中心轴插件
    /// </summary>
    public class CenterAxisPlugin : VideoPluginBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(CenterAxisPlugin));

        /// <summary>
        /// 中心轴插件
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public CenterAxisPlugin(VideoControl videoControl) : base(videoControl)
        {

        }

        /// <summary>
        /// 名称
        /// </summary>
        public override string Name => VideoControlPluginNames.CenterAxis;

        /// <summary>
        /// 中心轴信息
        /// </summary>
        private volatile CenterAxisInfo centerAxisInfo;

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="centerAxisInfo">中心轴信息</param>
        public void Update(CenterAxisInfo centerAxisInfo)
        {
            this.centerAxisInfo = centerAxisInfo;
        }

        /// <summary>
        /// 渲染
        /// </summary>
        /// <param name="context">渲染上下文</param>
        public override void Render(VideoRenderContext context)
        {
            CenterAxisInfo info = this.centerAxisInfo;
            if (info == null)
                return;

            // 绘制轴心
            RawVector2 drawCenter = ImageHelper.ConvertImagePointToUiPoint(context.VideoRenderInfo.Frame.Width, context.VideoRenderInfo.Frame.Height, context.VideoRenderInfo.DrawingRect, info.SrcCenter);
            SolidColorBrush brush = new SolidColorBrush(context.Target, info.AxisColor);

            // X轴
            RawVector2 x1 = new RawVector2((float)context.VideoRenderInfo.DrawingRect.Left, drawCenter.Y);
            RawVector2 x2 = new RawVector2((float)context.VideoRenderInfo.DrawingRect.Right, drawCenter.Y);
            context.Target.DrawLine(x1, x2, brush, (float)info.AxisWidth);

            // Y轴
            RawVector2 y1 = new RawVector2(drawCenter.X, (float)context.VideoRenderInfo.DrawingRect.Top);
            RawVector2 y2 = new RawVector2(drawCenter.X, (float)context.VideoRenderInfo.DrawingRect.Bottom);
            context.Target.DrawLine(y1, y2, brush, (float)info.AxisWidth);
        }
    }
}