﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 中心轴插件扩展
    /// </summary>
    public static class CenterAxisPluginExpand
    {
        /// <summary>
        /// 更新中心轴
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="centerAxisInfo">中心轴信息</param>
        public static void UpdateCenterAxis(this VideoControl videoControl, CenterAxisInfo centerAxisInfo)
        {
            if (videoControl.videoRender == null)
                return;

            CenterAxisPlugin plugin = videoControl.GetPlugin<CenterAxisPlugin>(VideoControlPluginNames.CenterAxis);
            if (plugin == null)
                return;

            plugin.Update(centerAxisInfo);
        }

        /// <summary>
        /// 清理中心轴
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public static void ClearCenterAxis(this VideoControl videoControl)
        {
            if (videoControl.videoRender == null)
                return;

            CenterAxisPlugin plugin = videoControl.GetPlugin<CenterAxisPlugin>(VideoControlPluginNames.CenterAxis);
            if (plugin == null)
                return;

            plugin.Update(null);
        }
    }
}
