﻿using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 跟踪框扩展
    /// </summary>
    public static class ClipBoxExpand
    {
        /// <summary>
        /// 更新跟踪框
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="clipBoxInfo">裁剪框信息</param>
        public static void UpdateClipBox(this VideoControl videoControl, ClipBoxInfo clipBoxInfo)
        {
            if (videoControl.videoRender == null)
                return;

            ClipBoxPlugin plugin = videoControl.GetPlugin<ClipBoxPlugin>(VideoControlPluginNames.ClipBox);
            if (plugin == null)
                return;

            plugin.Update(clipBoxInfo);
        }

        /// <summary>
        /// 更新裁切框边框颜色额
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="color">裁切框边框颜色</param>
        public static void UpdateClipBoxBorderColor(this VideoControl videoControl, RawColor4 color)
        {
            if (videoControl.videoRender == null)
                return;

            ClipBoxPlugin plugin = videoControl.GetPlugin<ClipBoxPlugin>(VideoControlPluginNames.ClipBox);
            if (plugin == null)
                return;

            plugin.UpdateBorderColor(color);
        }

        /// <summary>
        /// 清理跟踪框
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public static void ClearClipBox(this VideoControl videoControl)
        {
            if (videoControl.videoRender == null)
                return;

            ClipBoxPlugin plugin = videoControl.GetPlugin<ClipBoxPlugin>(VideoControlPluginNames.ClipBox);
            if (plugin == null)
                return;

            plugin.Update(null);
        }
    }
}
