﻿using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 手动校准扩展
    /// </summary>
    public static class ManualCorrectionExpand
    {
        /// <summary>
        /// 更新手动校准区域
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="manualCorrectionInfo">手动校准区域</param>
        public static void UpdateManualCorrection(this VideoControl videoControl, ManualCorrectionInfo manualCorrectionInfo)
        {
            if (videoControl.videoRender == null)
                return;

            ManualCorrectionPlugin plugin = videoControl.GetPlugin<ManualCorrectionPlugin>(VideoControlPluginNames.ManualCorrection);
            if (plugin == null)
                return;

            plugin.Update(manualCorrectionInfo);
        }

        /// <summary>
        /// 清理手动校准区域
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public static void ClearManualCorrection(this VideoControl videoControl)
        {
            if (videoControl.videoRender == null)
                return;

            ManualCorrectionPlugin plugin = videoControl.GetPlugin<ManualCorrectionPlugin>(VideoControlPluginNames.ManualCorrection);
            if (plugin == null)
                return;

            plugin.Update(null);
        }
    }
}
