﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using SharpDX;
using SharpDX.Direct2D1;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频渲染信息
    /// </summary>
    public class VideoRenderInfo : IDisposable
    {
        /// <summary>
        /// 视频帧信息
        /// </summary>
        public IVideoFrame Frame { get; set; }

        /// <summary>
        /// 渲染区域
        /// </summary>
        public Rect DrawingRect { get; set; }

        /// <summary>
        /// 控件区域
        /// </summary>
        public Rect ControlRect { get; set; }

        /// <summary>
        /// 该对象是否已经被销毁
        /// </summary>
        private bool IsDisopsed { get; set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            if (this.IsDisopsed)
                return;

            this.IsDisopsed = true;

            this.Frame?.Dispose();
        }
    }
}
