﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using NewTek;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 处理板卡视频帧任务
    /// </summary>
    public class BMDStreamExecuteVideoTask : BMDStreamTaskBase
    {
        /// <summary>
        /// 处理板卡视频帧任务
        /// </summary>
        /// <param name="stream">板卡流</param>
        public BMDStreamExecuteVideoTask(BMDStream stream) : base(stream)
        {

        }

        /// <summary>
        /// 任务名称
        /// </summary>
        public override BMDStreamTaskNames Name => BMDStreamTaskNames.EXECUTE_VIDEO;

        /// <summary>
        /// 执行
        /// </summary>
        protected override void Execute()
        {
            while (this.IsStarted)
            {
                if (this.Stream.VideoFrameQueue.Count <= this.Stream.Option.DelayFrame)
                {
                    Thread.Sleep(2);

                    continue;
                }

                if (!this.Stream.VideoFrameQueue.TryDequeue(out IVideoFrame frame))
                {
                    continue;
                }

                // 触发视频帧处理事件
                this.Stream.TriggerExecuteVideoFrame(frame);

                Thread.Sleep(10);
            }
        }
    }
}
