﻿using System;
using System.Diagnostics;
using DeckLinkAPI;

namespace VIZ.Framework.Common
{
    public class DeckLinkDiscoveryEventArgs : EventArgs
    {
        public readonly IDeckLink deckLink;

        public DeckLinkDiscoveryEventArgs(IDeckLink deckLink)
        {
            this.deckLink = deckLink;
        }
    }

    public class DeckLinkDeviceNotification : IDeckLinkDeviceNotificationCallback
    {
        private IDeckLinkDiscovery deviceDiscover;

        public event EventHandler<DeckLinkDiscoveryEventArgs> deviceArrived;
        public event EventHandler<DeckLinkDiscoveryEventArgs> deviceRemoved;

        public DeckLinkDeviceNotification()
        {
            deviceDiscover = new CDeckLinkDiscovery();
            deviceDiscover.InstallDeviceNotifications(this);
        }

        ~DeckLinkDeviceNotification()
        {
            deviceDiscover.UninstallDeviceNotifications();
        }

        void IDeckLinkDeviceNotificationCallback.DeckLinkDeviceArrived(IDeckLink deckLinkDevice)
        {
            string deckLinkModelName;
            deckLinkDevice.GetModelName(out deckLinkModelName);
            Debug.WriteLine("Device arrived " + deckLinkModelName);

            var handler = deviceArrived;
            if (handler != null)
            {
                handler.Invoke(this, new DeckLinkDiscoveryEventArgs(deckLinkDevice));
            }
        }

        void IDeckLinkDeviceNotificationCallback.DeckLinkDeviceRemoved(IDeckLink deckLinkDevice)
        {
            string deckLinkModelName;
            deckLinkDevice.GetModelName(out deckLinkModelName);
            Debug.WriteLine("Device removed " + deckLinkModelName);

            var handler = deviceRemoved;
            if (handler != null)
            {
                handler.Invoke(this, new DeckLinkDiscoveryEventArgs(deckLinkDevice));
            }
        }
    }
}