﻿using DeckLinkAPI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// DeckLink视频帧
    /// </summary>
    public class DeckLinkVideoFrame : IDeckLinkVideoFrame
    {
        /// <summary>
        /// 宽度
        /// </summary>
        public int Width { get; private set; }

        /// <summary>
        /// 高度
        /// </summary>
        public int Height { get; private set; }

        /// <summary>
        /// 标记
        /// </summary>
        public _BMDFrameFlags Flags{ get; private set; }

        /// <summary>
        /// 数据长度
        /// </summary>
        public int BufferBytes { get; private set; }

        /// <summary>
        /// 数据地址
        /// </summary>
        public IntPtr Buffer { get; private set; }

        /// <summary>
        /// DeckLink视频帧数据
        /// </summary>
        /// <param name="width">宽度</param>
        /// <param name="height">高度</param>
        /// <param name="flags">标记</param>
        public DeckLinkVideoFrame(int width, int height, _BMDFrameFlags flags)
        {
            this.Width = width;
            this.Height = height;
            this.Flags = flags;

            this.BufferBytes = width * height * 4;

            // Allocate pixel buffer from unmanaged memory
            this.Buffer = System.Runtime.InteropServices.Marshal.AllocCoTaskMem(this.BufferBytes);

            // Inform runtime of large unmanaged memory allocation for scheduling garbage collection
            System.GC.AddMemoryPressure(this.BufferBytes);
        }

        ~DeckLinkVideoFrame()
        {
            // Free pixel buffer from unmanaged memory
            if (this.Buffer != IntPtr.Zero)
            {
                System.Runtime.InteropServices.Marshal.FreeCoTaskMem(this.Buffer);
                System.GC.RemoveMemoryPressure(this.BufferBytes);

                this.Buffer = IntPtr.Zero;
            }
        }

        public int GetWidth()
        {
            return this.Width;
        }

        public int GetHeight()
        {
            return this.Height;
        }

        public int GetRowBytes()
        {
            return this.Width * 4;
        }

        public void GetBytes(out IntPtr buffer)
        {
            buffer = this.Buffer;
        }

        public _BMDFrameFlags GetFlags()
        {
            return this.Flags;
        }

        public _BMDPixelFormat GetPixelFormat()
        {
            return _BMDPixelFormat.bmdFormat8BitBGRA;
        }

        // Dummy implementations of remaining methods
        void IDeckLinkVideoFrame.GetAncillaryData(out IDeckLinkVideoFrameAncillary ancillary)
        {
            throw new NotImplementedException();
        }

        void IDeckLinkVideoFrame.GetTimecode(_BMDTimecodeFormat format, out IDeckLinkTimecode timecode)
        {
            throw new NotImplementedException();
        }
    }
}
