﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using log4net;
using DeckLinkAPI;
using System.Windows.Markup;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// DeckLink流
    /// </summary>
    public class DeckLinkStream : VideoStreamBase<DeckLinkStreamOption>
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(DeckLinkStream));

        /// <summary>
        /// DeckLink流
        /// </summary>
        /// <param name="device">DeckLink设备</param>
        /// <param name="option">设置</param>
        public DeckLinkStream(DeckLinkInputDevice device, DeckLinkStreamOption option)
            : base(option)
        {
            // 处理视频帧任务
            this.TaskDic.Add(DeckLinkStreamTaskNames.EXECUTE_VIDEO, new DeckLinkStreamExecuteVideoTask(this));

            DeckLinkManager.Invoke(() =>
            {
                this.Conversion = new CDeckLinkVideoConversion();

                this.Device = device;
            });
        }

        /* ========================================================================================================= */
        /* === Const === */
        /* ========================================================================================================= */



        /* ========================================================================================================= */
        /* === Property === */
        /* ========================================================================================================= */

        /// <summary>
        /// 是否正在捕获
        /// </summary>
        public bool IsCapturing { get; private set; }

        /// <summary>
        /// DeckLink设备
        /// </summary>
        internal DeckLinkInputDevice Device;

        /// <summary>
        /// 
        /// </summary>
        internal IDeckLinkVideoConversion Conversion;

        /* ========================================================================================================= */
        /* === Internal Field === */
        /* ========================================================================================================= */


        /* ========================================================================================================= */
        /* === Field === */
        /* ========================================================================================================= */

        /// <summary>
        /// 任务池
        /// </summary>
        private Dictionary<DeckLinkStreamTaskNames, DeckLinkStreamTaskBase> TaskDic = new Dictionary<DeckLinkStreamTaskNames, DeckLinkStreamTaskBase>();

        /* ========================================================================================================= */
        /* === Function === */
        /* ========================================================================================================= */

        /// <summary>
        /// 开始
        /// </summary>
        public void Start()
        {
            // 启动NDI视频帧处理任务
            this.TaskDic[DeckLinkStreamTaskNames.EXECUTE_VIDEO].Start();

            DeckLinkManager.Invoke(() =>
            {
                this.Device.VideoFrameArrivedHandler += Device_VideoFrameArrivedHandler;
                this.Device.StartCapture();
                this.IsCapturing = true;
            });
        }

        /// <summary>
        /// 停止
        /// </summary>
        public void Stop()
        {
            if (!this.IsCapturing)
                return;

            // 停止所有任务
            foreach (var task in this.TaskDic.Values)
            {
                task.Stop();
            }

            DeckLinkManager.Invoke(() =>
            {
                this.Device.VideoFrameArrivedHandler -= Device_VideoFrameArrivedHandler;
                this.Device.StopCapture();
                this.IsCapturing = false;
            });
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public override void Dispose()
        {
            this.Stop();
        }

        /// <summary>
        /// 处理视频帧
        /// </summary>
        private void Device_VideoFrameArrivedHandler(object sender, DeckLinkVideoFrameArrivedEventArgs e)
        {
            try
            {
                int width = e.videoFrame.GetWidth();
                int height = e.videoFrame.GetHeight();
                _BMDFrameFlags flags = e.videoFrame.GetFlags();

                DeckLinkVideoFrame frame = new DeckLinkVideoFrame(width, height, flags);

                this.Conversion.ConvertFrame(e.videoFrame, frame);

                DeckLinkStreamVideoFrame videoFrame = new DeckLinkStreamVideoFrame();
                videoFrame.Width = width;
                videoFrame.Height = height;
                videoFrame.Length = width * height * 4;
                //videoFrame.TimeStamp = 
                videoFrame.DataStream = new SharpDX.DataStream(videoFrame.Length, true, true);
                unsafe
                {
                    Buffer.MemoryCopy(frame.Buffer.ToPointer(), videoFrame.DataStream.DataPointer.ToPointer(), videoFrame.Length, videoFrame.Length);
                }

                this.VideoFrameQueue.Enqueue(videoFrame);
            }
            catch (Exception ex)
            {
                log.Error(ex);
            }
        }
    }
}