﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 颜色拾取按钮
    /// </summary>
    public class ColorPickButton : Button
    {
        static ColorPickButton()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(ColorPickButton), new FrameworkPropertyMetadata(typeof(ColorPickButton)));
        }

        #region Color -- 颜色

        /// <summary>
        /// 颜色
        /// </summary>
        public Color Color
        {
            get { return (Color)GetValue(ColorProperty); }
            set { SetValue(ColorProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Color.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty ColorProperty =
            DependencyProperty.Register("Color", typeof(Color), typeof(ColorPickButton), new PropertyMetadata(Colors.Red, new PropertyChangedCallback((s, e) =>
            {
                (s as ColorPickButton).Background = new SolidColorBrush((Color)e.NewValue);
            })));

        #endregion

        protected override void OnClick()
        {
            base.OnClick();

            ColorPickWindow window = new ColorPickWindow();
            window.Owner = Window.GetWindow(this);
            window.OldColor = this.Color;
            window.SelectedColor = this.Color;

            if (window.ShowDialog() != true)
                return;

            this.Color = window.SelectedColor;
        }
    }
}
