﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Xceed.Wpf.Toolkit;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// ColorPickWindow.xaml 的交互逻辑
    /// </summary>
    public partial class ColorPickWindow : Window
    {
        public ColorPickWindow()
        {
            InitializeComponent();
        }

        #region SelectedColor -- 选择的颜色

        /// <summary>
        /// 选择的颜色
        /// </summary>
        public Color SelectedColor
        {
            get { return (Color)GetValue(SelectedColorProperty); }
            set { SetValue(SelectedColorProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for SelectedColor.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty SelectedColorProperty =
            DependencyProperty.Register("SelectedColor", typeof(Color), typeof(ColorPickWindow), new PropertyMetadata(Colors.Red));

        #endregion

        #region OldColor -- 原始颜色

        /// <summary>
        /// 原始颜色
        /// </summary>
        public Color OldColor
        {
            get { return (Color)GetValue(OldColorProperty); }
            set { SetValue(OldColorProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for OldColor.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty OldColorProperty =
            DependencyProperty.Register("OldColor", typeof(Color), typeof(ColorPickWindow), new PropertyMetadata(Colors.Transparent));

        #endregion

        /// <summary>
        /// 确定
        /// </summary>
        private void btEnter_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = true;
            this.Close();
        }

        /// <summary>
        /// 取消
        /// </summary>
        private void btCancel_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = false;
            this.Close();
        }

        /// <summary>
        /// 还原
        /// </summary>
        private void btReset_Click(object sender, RoutedEventArgs e)
        {
            this.SelectedColor = this.OldColor;
        }
    }
}
