﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 显示消息控件
    /// </summary>
    public class ShowMessageControl : Control
    {
        static ShowMessageControl()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(ShowMessageControl), new FrameworkPropertyMetadata(typeof(ShowMessageControl)));
        }

        public ShowMessageControl()
        {
            this.Loaded += ShowMessageControl_Loaded;
        }

        #region Message -- 消息

        /// <summary>
        /// 消息
        /// </summary>
        public string Message
        {
            get { return (string)GetValue(MessageProperty); }
            set { SetValue(MessageProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Message.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty MessageProperty =
            DependencyProperty.Register("Message", typeof(string), typeof(ShowMessageControl), new PropertyMetadata(null));

        #endregion

        #region IsShow -- 是否显示

        /// <summary>
        /// 是否显示
        /// </summary>
        public bool IsShow
        {
            get { return (bool)GetValue(IsShowProperty); }
            set { SetValue(IsShowProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for IsShow.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty IsShowProperty =
            DependencyProperty.Register("IsShow", typeof(bool), typeof(ShowMessageControl), new PropertyMetadata(false));

        #endregion

        #region MessageKey -- 消息键

        /// <summary>
        /// 消息键
        /// </summary>
        public string MessageKey
        {
            get { return (string)GetValue(MessageKeyProperty); }
            set { SetValue(MessageKeyProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for MessageKey.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty MessageKeyProperty =
            DependencyProperty.Register("MessageKey", typeof(string), typeof(ShowMessageControl), new PropertyMetadata(null));

        #endregion

        #region MessageShowDuration -- 消息显示持续时间

        /// <summary>
        /// 消息显示持续时间
        /// </summary>
        public TimeSpan MessageShowDuration
        {
            get { return (TimeSpan)GetValue(MessageShowDurationProperty); }
            set { SetValue(MessageShowDurationProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for MessageShowDuration.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty MessageShowDurationProperty =
            DependencyProperty.Register("MessageShowDuration", typeof(TimeSpan), typeof(ShowMessageControl), new PropertyMetadata(TimeSpan.FromSeconds(2)));

        #endregion

        /// <summary>
        /// 是否已经完成加载
        /// </summary>
        private bool isAlreadyLoaded;

        /// <summary>
        /// 加载完成
        /// </summary>
        private void ShowMessageControl_Loaded(object sender, RoutedEventArgs e)
        {
            if (this.isAlreadyLoaded || ApplicationDomain.MessageManager == null)
                return;

            ApplicationDomain.MessageManager.Register<ShowMessage>(this, this.ExecuteMessage);

            this.isAlreadyLoaded = true;
        }

        /// <summary>
        /// 执行消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void ExecuteMessage(ShowMessage msg)
        {
            if (this.MessageKey != msg.MessageKey)
                return;

            WPFHelper.BeginInvoke(() =>
            {
                this.Message = msg.Message;
                this.IsShow = true;

                ApplicationDomain.DelayManager.Wait($"ShowMessageControl__{this.MessageKey}", this.MessageShowDuration, () =>
                {
                    WPFHelper.BeginInvoke(() =>
                    {
                        this.IsShow = false;
                    });
                });
            });
        }
    }
}
