/*----------------------------------------------------------------------
*  siSyncDefines.h -- 3DxWare GUI Synchronization defines and enums
*
*  Just defines and enums for SiSync functions
*
* Written:     September 2004
* Author:      Jim Wick
*
*----------------------------------------------------------------------
*
* Copyright notice:
* Copyright (c) 1998-2015 3Dconnexion. All rights reserved.
*
* This file and source code are an integral part of the "3Dconnexion
* Software Developer Kit", including all accompanying documentation,
* and is protected by intellectual property laws. All use of the
* 3Dconnexion Software Developer Kit is subject to the License
* Agreement found in the "LicenseAgreementSDK.txt" file.
* All rights not expressly granted by 3Dconnexion are reserved.
*
*/
#ifndef _SISYNCDEFINES_H_
#define _SISYNCDEFINES_H_

static char siSyncDefinesCvsId[] = "(C) 2012-2018 3Dconnexion: $Id: siSyncDefines.h 14646 2018-01-04 15:08:23Z jwick $";

/*
* Constants
*/
#define SI_SYNC_PACKET_ID 27711
#define SI_SYNC_VERSION_MAJOR 2
#define SI_SYNC_VERSION_MINOR 0

/*
* Absolute Internal Function Numbers
* These are function numbers that will never change.
* For use with Set BUTTON_ASSIGNMENT_ABSOLUTE packets, and some INVOKE items.
* Some functions (keys) can not be INVOKED because there is a separate
* press and release and that difference is not exposed.
*/
typedef enum
{
  SI_SYNC_FUNCTION_MENU_TOGGLE = 12,
  SI_SYNC_FUNCTION_TRANS_TOGGLE = 13,
  SI_SYNC_FUNCTION_ROT_TOGGLE = 14,
  SI_SYNC_FUNCTION_HPV_TOGGLE = 15,
  SI_SYNC_FUNCTION_DEC_SENS = 16,
  SI_SYNC_FUNCTION_INC_SENS = 17,
  SI_SYNC_FUNCTION_RESTORE_DEF = 18,
  SI_SYNC_FUNCTION_PAN = 19,
  SI_SYNC_FUNCTION_ZOOM = 20,
  SI_SYNC_FUNCTION_TX = 21,
  SI_SYNC_FUNCTION_TY = 22,
  SI_SYNC_FUNCTION_TZ = 23,
  SI_SYNC_FUNCTION_RX = 24,
  SI_SYNC_FUNCTION_RY = 25,
  SI_SYNC_FUNCTION_RZ = 26,
  SI_SYNC_FUNCTION_REZERO_DEVICE = 27,
  SI_SYNC_FUNCTION_SAVE = 33,
  SI_SYNC_FUNCTION_RELOAD = 57,
  SI_SYNC_FUNCTION_SHIFT_KEY = 60,
  SI_SYNC_FUNCTION_CTRL_KEY = 61,
  SI_SYNC_FUNCTION_ALT_KEY = 62,
  SI_SYNC_FUNCTION_RESTORE_SENS = 63,
  SI_SYNC_FUNCTION_SPACE_KEY = 64,
  SI_SYNC_FUNCTION_CTRL_SHIFT_KEY = 65,
  SI_SYNC_FUNCTION_CTRL_ALT_KEY = 66,
  SI_SYNC_FUNCTION_SHIFT_ALT_KEY = 67,
  SI_SYNC_FUNCTION_TAB_KEY = 68,
  SI_SYNC_FUNCTION_RETURN_KEY = 69,
  SI_SYNC_FUNCTION_DEC_TRANS_SENS = 70,
  SI_SYNC_FUNCTION_INC_TRANS_SENS = 71,
  SI_SYNC_FUNCTION_DEC_ROT_SENS = 72,
  SI_SYNC_FUNCTION_INC_ROT_SENS = 73,
  SI_SYNC_FUNCTION_DEC_PAN_SENS = 74,
  SI_SYNC_FUNCTION_INC_PAN_SENS = 75,
  SI_SYNC_FUNCTION_DEC_ZOOM_SENS = 76,
  SI_SYNC_FUNCTION_INC_ZOOM_SENS = 77,
  SI_SYNC_FUNCTION_ESC_KEY = 78,
  SI_SYNC_FUNCTION_3DX_HELP = 94,
  SI_SYNC_FUNCTION_APP_HELP = 95,
  SI_SYNC_FUNCTION_DIALOG_TOGGLE_FN = 96,
  SI_SYNC_FUNCTION_FIT_FN = 97,
  SI_SYNC_FUNCTION_TOGGLE_3DXLCD_FN = 198,
  SI_SYNC_FUNCTION_TOGGLE_3DXNUMPAD_FN = 199,
  SI_SYNC_FUNCTION_LAUNCH_3DXPIE_LEFT_FN = 200,
  SI_SYNC_FUNCTION_LAUNCH_3DXPIE_RIGHT_FN = 201,
  SI_SYNC_FUNCTION_SPPDEF_MENU_FN = 202,
  SI_SYNC_FUNCTION_SPPDEF_FIT_FN = 203,
  SI_SYNC_FUNCTION_APP_SHOW_BUTTONMAPPINGEDITOR_FN = 204,
  SI_SYNC_FUNCTION_APP_SHOW_ADVANCEDSETTINGSEDITOR_FN = 205,
  SI_SYNC_FUNCTION_SENTINEL = 206,  // Sentinel for indicating the last valid function.  Keep it up-to-date.
} SiSyncAbsFunctionNumber;

#ifndef _3DXSERVICE
WCHAR* SiSyncAbsFunctionNumber_ToString(SiSyncAbsFunctionNumber functionNumber);
#else
static WCHAR* SiSyncAbsFunctionNumber_ToString(SiSyncAbsFunctionNumber functionNumber)
{
  switch (functionNumber)
  {
  case SI_SYNC_FUNCTION_MENU_TOGGLE:	return L"SI_SYNC_FUNCTION_MENU_TOGGLE";
  case SI_SYNC_FUNCTION_TRANS_TOGGLE:	return L"SI_SYNC_FUNCTION_TRANS_TOGGLE";
  case SI_SYNC_FUNCTION_ROT_TOGGLE:	return L"SI_SYNC_FUNCTION_ROT_TOGGLE";
  case SI_SYNC_FUNCTION_HPV_TOGGLE:	return L"SI_SYNC_FUNCTION_HPV_TOGGLE";
  case SI_SYNC_FUNCTION_DEC_SENS:	return L"SI_SYNC_FUNCTION_DEC_SENS";
  case SI_SYNC_FUNCTION_INC_SENS:	return L"SI_SYNC_FUNCTION_INC_SENS";
  case SI_SYNC_FUNCTION_RESTORE_DEF:	return L"SI_SYNC_FUNCTION_RESTORE_DEF";
  case SI_SYNC_FUNCTION_PAN:	return L"SI_SYNC_FUNCTION_PAN";
  case SI_SYNC_FUNCTION_ZOOM:	return L"SI_SYNC_FUNCTION_ZOOM";
  case SI_SYNC_FUNCTION_TX:	return L"SI_SYNC_FUNCTION_TX";
  case SI_SYNC_FUNCTION_TY:	return L"SI_SYNC_FUNCTION_TY";
  case SI_SYNC_FUNCTION_TZ:	return L"SI_SYNC_FUNCTION_TZ";
  case SI_SYNC_FUNCTION_RX:	return L"SI_SYNC_FUNCTION_RX";
  case SI_SYNC_FUNCTION_RY:	return L"SI_SYNC_FUNCTION_RY";
  case SI_SYNC_FUNCTION_RZ:	return L"SI_SYNC_FUNCTION_RZ";
  case SI_SYNC_FUNCTION_REZERO_DEVICE:	return L"SI_SYNC_FUNCTION_REZERO_DEVICE";
  case SI_SYNC_FUNCTION_SAVE:	return L"SI_SYNC_FUNCTION_SAVE";
  case SI_SYNC_FUNCTION_RELOAD:	return L"SI_SYNC_FUNCTION_RELOAD";
  case SI_SYNC_FUNCTION_SHIFT_KEY:	return L"SI_SYNC_FUNCTION_SHIFT_KEY";
  case SI_SYNC_FUNCTION_CTRL_KEY:	return L"SI_SYNC_FUNCTION_CTRL_KEY";
  case SI_SYNC_FUNCTION_ALT_KEY:	return L"SI_SYNC_FUNCTION_ALT_KEY";
  case SI_SYNC_FUNCTION_RESTORE_SENS:	return L"SI_SYNC_FUNCTION_RESTORE_SENS";
  case SI_SYNC_FUNCTION_SPACE_KEY:	return L"SI_SYNC_FUNCTION_SPACE_KEY";
  case SI_SYNC_FUNCTION_CTRL_SHIFT_KEY:	return L"SI_SYNC_FUNCTION_CTRL_SHIFT_KEY";
  case SI_SYNC_FUNCTION_CTRL_ALT_KEY:	return L"SI_SYNC_FUNCTION_CTRL_ALT_KEY";
  case SI_SYNC_FUNCTION_SHIFT_ALT_KEY:	return L"SI_SYNC_FUNCTION_SHIFT_ALT_KEY";
  case SI_SYNC_FUNCTION_TAB_KEY:	return L"SI_SYNC_FUNCTION_TAB_KEY";
  case SI_SYNC_FUNCTION_RETURN_KEY:	return L"SI_SYNC_FUNCTION_RETURN_KEY";
  case SI_SYNC_FUNCTION_DEC_TRANS_SENS:	return L"SI_SYNC_FUNCTION_DEC_TRANS_SENS";
  case SI_SYNC_FUNCTION_INC_TRANS_SENS:	return L"SI_SYNC_FUNCTION_INC_TRANS_SENS";
  case SI_SYNC_FUNCTION_DEC_ROT_SENS:	return L"SI_SYNC_FUNCTION_DEC_ROT_SENS";
  case SI_SYNC_FUNCTION_INC_ROT_SENS:	return L"SI_SYNC_FUNCTION_INC_ROT_SENS";
  case SI_SYNC_FUNCTION_DEC_PAN_SENS:	return L"SI_SYNC_FUNCTION_DEC_PAN_SENS";
  case SI_SYNC_FUNCTION_INC_PAN_SENS:	return L"SI_SYNC_FUNCTION_INC_PAN_SENS";
  case SI_SYNC_FUNCTION_DEC_ZOOM_SENS:	return L"SI_SYNC_FUNCTION_DEC_ZOOM_SENS";
  case SI_SYNC_FUNCTION_INC_ZOOM_SENS:	return L"SI_SYNC_FUNCTION_INC_ZOOM_SENS";
  case SI_SYNC_FUNCTION_ESC_KEY:	return L"SI_SYNC_FUNCTION_ESC_KEY";
  case SI_SYNC_FUNCTION_3DX_HELP:	return L"SI_SYNC_FUNCTION_3DX_HELP";
  case SI_SYNC_FUNCTION_APP_HELP:	return L"SI_SYNC_FUNCTION_APP_HELP";
  case SI_SYNC_FUNCTION_DIALOG_TOGGLE_FN:	return L"SI_SYNC_FUNCTION_DIALOG_TOGGLE_FN";
  case SI_SYNC_FUNCTION_FIT_FN:	return L"SI_SYNC_FUNCTION_FIT_FN";
  case SI_SYNC_FUNCTION_TOGGLE_3DXLCD_FN:	return L"SI_SYNC_FUNCTION_TOGGLE_3DXLCD_FN";
  case SI_SYNC_FUNCTION_TOGGLE_3DXNUMPAD_FN:	return L"SI_SYNC_FUNCTION_TOGGLE_3DXNUMPAD_FN";
  case SI_SYNC_FUNCTION_LAUNCH_3DXPIE_LEFT_FN:	return L"SI_SYNC_FUNCTION_LAUNCH_3DXPIE_LEFT_FN";
  case SI_SYNC_FUNCTION_LAUNCH_3DXPIE_RIGHT_FN:	return L"SI_SYNC_FUNCTION_LAUNCH_3DXPIE_RIGHT_FN";
  case SI_SYNC_FUNCTION_SPPDEF_MENU_FN:	return L"SI_SYNC_FUNCTION_SPPDEF_MENU_FN";
  case SI_SYNC_FUNCTION_SPPDEF_FIT_FN:	return L"SI_SYNC_FUNCTION_SPPDEF_FIT_FN";
  case SI_SYNC_FUNCTION_APP_SHOW_BUTTONMAPPINGEDITOR_FN:	return L"SI_SYNC_FUNCTION_APP_SHOW_BUTTONMAPPINGEDITOR_FN";
  case SI_SYNC_FUNCTION_APP_SHOW_ADVANCEDSETTINGSEDITOR_FN:	return L"SI_SYNC_FUNCTION_APP_SHOW_ADVANCEDSETTINGSEDITOR_FN";
  default:	return L"invalid";
  }
};
#endif

/*
* Sync Op Codes
*/
typedef enum
{
  SI_SYNC_OP_COMMAND = 1,
  SI_SYNC_OP_GET = 2,
  SI_SYNC_OP_SET = 3
} SiSyncOpCode;

#ifndef _3DXSERVICE
WCHAR* SiSyncOpCode_ToString(SiSyncOpCode code);
#else
static WCHAR* SiSyncOpCode_ToString(SiSyncOpCode code)
{
  switch (code)
  {
  case SI_SYNC_OP_COMMAND: return L"SI_SYNC_OP_COMMAND";
  case SI_SYNC_OP_GET: return L"SI_SYNC_OP_GET";
  case SI_SYNC_OP_SET: return L"SI_SYNC_OP_SET";
  default: return L"invalid";
  }
};
#endif

/*
* Sync Item Codes
*/
typedef enum
{
  SI_SYNC_ITEM_VERSION = 1,
  SI_SYNC_ITEM_QUERY = 2,
  SI_SYNC_ITEM_SAVE_CONFIG = 3,
  SI_SYNC_ITEM_NUMBER_OF_FUNCTIONS = 4,
  SI_SYNC_ITEM_FUNCTION = 5,
  SI_SYNC_ITEM_BUTTON_ASSIGNMENT = 6,
  SI_SYNC_ITEM_BUTTON_ASSIGNMENT_ABSOLUTE = 7,
  SI_SYNC_ITEM_BUTTON_NAME = 8,
  SI_SYNC_ITEM_AXIS_LABEL = 9,
  SI_SYNC_ITEM_ORIENTATION = 10,
  SI_SYNC_ITEM_FILTER = 11,
  SI_SYNC_ITEM_AXES_STATE = 12,
  SI_SYNC_ITEM_INFO_LINE = 13,
  SI_SYNC_ITEM_SCALE_OVERALL = 14,
  SI_SYNC_ITEM_SCALE_TX = 15,
  SI_SYNC_ITEM_SCALE_TY = 16,
  SI_SYNC_ITEM_SCALE_TZ = 17,
  SI_SYNC_ITEM_SCALE_RX = 18,
  SI_SYNC_ITEM_SCALE_RY = 19,
  SI_SYNC_ITEM_SCALE_RZ = 20,
  SI_SYNC_ITEM_INVOKE_ABSOLUTE_FUNCTION = 21,
  SI_SYNC_ITEM_BUTTON_STATE = 22,
  SI_SYNC_ITEM_INJECT_BUTTON_EVENT = 23,
  SI_SYNC_ITEM_SUSPEND_FILE_WRITING = 24,
  SI_SYNC_ITEM_INVOKE_ACTIONID = 25,
  SI_SYNC_ITEM_CREATE_BUTTONBANK = 26,
  SI_SYNC_ITEM_DELETE_BUTTONBANK = 27,
  SI_SYNC_ITEM_CURRENTBUTTONBANK = 28,
  SI_SYNC_ITEM_PREVIOUSBUTTONBANK = 29,
  SI_SYNC_ITEM_NEXTBUTTONBANK = 30,
  SI_SYNC_ITEM_GRAB_SYNCID = 31,
  SI_SYNC_ITEM_SYNCID = 32,
  SI_SYNC_ITEM_CREATE_AXISBANK = 33,
  SI_SYNC_ITEM_DELETE_AXISBANK = 34,
  SI_SYNC_ITEM_CURRENTAXISBANK = 35,
  SI_SYNC_ITEM_PREVIOUSAXISBANK = 36,
  SI_SYNC_ITEM_NEXTAXISBANK = 37,
  SI_SYNC_ITEM_CREATE_APPLICATIONBANK = 38,
  SI_SYNC_ITEM_DELETE_APPLICATIONBANK = 39,
  SI_SYNC_ITEM_CURRENTAPPLICATIONBANK = 40,
  SI_SYNC_ITEM_PREVIOUSAPPLICATIONBANK = 41,
  SI_SYNC_ITEM_NEXTAPPLICATIONBANK = 42,
  SI_SYNC_ITEM_BUTTON_ASSIGNMENT_V3DKEY = 43,
} SiSyncItemCode;

#ifndef _3DXSERVICE
WCHAR* SiSyncItemCode_ToString(SiSyncItemCode code);
#else
static WCHAR* SiSyncItemCode_ToString(SiSyncItemCode code)
{
  switch (code)
  {
  case SI_SYNC_ITEM_VERSION: return L"SI_SYNC_ITEM_VERSION";
  case SI_SYNC_ITEM_QUERY: return L"SI_SYNC_ITEM_QUERY";
  case SI_SYNC_ITEM_SAVE_CONFIG: return L"SI_SYNC_ITEM_SAVE_CONFIG";
  case SI_SYNC_ITEM_NUMBER_OF_FUNCTIONS: return L"SI_SYNC_ITEM_NUMBER_OF_FUNCTIONS";
  case SI_SYNC_ITEM_FUNCTION: return L"SI_SYNC_ITEM_FUNCTION";
  case SI_SYNC_ITEM_BUTTON_ASSIGNMENT: return L"SI_SYNC_ITEM_BUTTON_ASSIGNMENT";
  case SI_SYNC_ITEM_BUTTON_ASSIGNMENT_ABSOLUTE: return L"SI_SYNC_ITEM_BUTTON_ASSIGNMENT_ABSOLUTE";
  case SI_SYNC_ITEM_BUTTON_NAME: return L"SI_SYNC_ITEM_BUTTON_NAME";
  case SI_SYNC_ITEM_AXIS_LABEL: return L"SI_SYNC_ITEM_AXIS_LABEL";
  case SI_SYNC_ITEM_ORIENTATION: return L"SI_SYNC_ITEM_ORIENTATION";
  case SI_SYNC_ITEM_FILTER: return L"SI_SYNC_ITEM_FILTER";
  case SI_SYNC_ITEM_AXES_STATE: return L"SI_SYNC_ITEM_AXES_STATE";
  case SI_SYNC_ITEM_INFO_LINE: return L"SI_SYNC_ITEM_INFO_LINE";
  case SI_SYNC_ITEM_SCALE_OVERALL: return L"SI_SYNC_ITEM_SCALE_OVERALL";
  case SI_SYNC_ITEM_SCALE_TX: return L"SI_SYNC_ITEM_SCALE_TX";
  case SI_SYNC_ITEM_SCALE_TY: return L"SI_SYNC_ITEM_SCALE_TY";
  case SI_SYNC_ITEM_SCALE_TZ: return L"SI_SYNC_ITEM_SCALE_TZ";
  case SI_SYNC_ITEM_SCALE_RX: return L"SI_SYNC_ITEM_SCALE_RX";
  case SI_SYNC_ITEM_SCALE_RY: return L"SI_SYNC_ITEM_SCALE_RY";
  case SI_SYNC_ITEM_SCALE_RZ: return L"SI_SYNC_ITEM_SCALE_RZ";
  case SI_SYNC_ITEM_INVOKE_ABSOLUTE_FUNCTION: return L"SI_SYNC_ITEM_INVOKE_ABSOLUTE_FUNCTION";
  case SI_SYNC_ITEM_BUTTON_STATE: return L"SI_SYNC_ITEM_BUTTON_STATE";
  case SI_SYNC_ITEM_INJECT_BUTTON_EVENT: return L"SI_SYNC_ITEM_INJECT_BUTTON_EVENT";
  case SI_SYNC_ITEM_SUSPEND_FILE_WRITING: return L"SI_SYNC_ITEM_SUSPEND_FILE_WRITING";
  case SI_SYNC_ITEM_INVOKE_ACTIONID: return L"SI_SYNC_ITEM_INVOKE_ACTIONID";
  case SI_SYNC_ITEM_CREATE_BUTTONBANK: return L"SI_SYNC_ITEM_CREATE_BUTTONBANK";
  case SI_SYNC_ITEM_DELETE_BUTTONBANK: return L"SI_SYNC_ITEM_DELETE_BUTTONBANK";
  case SI_SYNC_ITEM_CURRENTBUTTONBANK: return L"SI_SYNC_ITEM_CURRENTBUTTONBANK";
  case SI_SYNC_ITEM_PREVIOUSBUTTONBANK: return L"SI_SYNC_ITEM_PREVIOUSBUTTONBANK";
  case SI_SYNC_ITEM_NEXTBUTTONBANK: return L"SI_SYNC_ITEM_NEXTBUTTONBANK";
  case SI_SYNC_ITEM_GRAB_SYNCID: return L"SI_SYNC_ITEM_GRAB_SYNCID";
  case SI_SYNC_ITEM_SYNCID: return L"SI_SYNC_ITEM_SYNCID";
  default: return L"invalid";
  }
};
#endif

/*
* Filters
*/
typedef enum
{
  SI_SYNC_FILTER_TRANSLATIONS = 1,
  SI_SYNC_FILTER_ROTATIONS = 2,
  SI_SYNC_FILTER_DOMINANT = 3
} SiSyncFilter;

#ifndef _3DXSERVICE
WCHAR* SiSyncFilter_ToString(SiSyncFilter filter);
#else
static WCHAR* SiSyncFilter_ToString(SiSyncFilter filter)
{
  switch (filter)
  {
  case SI_SYNC_FILTER_TRANSLATIONS: return L"SI_SYNC_FILTER_TRANSLATIONS";
  case SI_SYNC_FILTER_ROTATIONS: return L"SI_SYNC_FILTER_ROTATIONS";
  case SI_SYNC_FILTER_DOMINANT: return L"SI_SYNC_FILTER_DOMINANT";
  default: return L"invalid";
  }
}
#endif

typedef enum
{
  SI_SYNC_FILTER_OFF = 0,
  SI_SYNC_FILTER_ON = 1,
  SI_SYNC_FILTER_IN_BETWEEN = 2
} SiSyncFilterValue;

#ifndef _3DXSERVICE
WCHAR* SiSyncFilterValue_ToString(SiSyncFilterValue filterValue);
#else
static WCHAR* SiSyncFilterValue_ToString(SiSyncFilterValue filterValue)
{
  switch (filterValue)
  {
  case SI_SYNC_FILTER_OFF: return L"SI_SYNC_FILTER_OFF";
  case SI_SYNC_FILTER_ON: return L"SI_SYNC_FILTER_ON";
  case SI_SYNC_FILTER_IN_BETWEEN: return L"SI_SYNC_FILTER_IN_BETWEEN";
  default: return L"invalid";
  }
};
#endif

/*
* Axes State
*/
typedef enum
{
  SI_SYNC_AXES_STATE_TX = (1 << 0),
  SI_SYNC_AXES_STATE_TY = (1 << 1),
  SI_SYNC_AXES_STATE_TZ = (1 << 2),
  SI_SYNC_AXES_STATE_RX = (1 << 3),
  SI_SYNC_AXES_STATE_RY = (1 << 4),
  SI_SYNC_AXES_STATE_RZ = (1 << 5)
} SiSyncAxesStateBits;

/*
* Button State
* For indicating the state of whatever the button sets (in the LCD at this point).
* E.g., to show that Translations are currently OFF for the Translations Toggle button.
* OFF: reverse video, flag is not set
* ON: normal video, flag is set
* DISABLED: (greyed), status of flag is invalid at this time
*/
typedef enum
{
  SI_SYNC_BUTTON_STATE_OFF = 0,
  SI_SYNC_BUTTON_STATE_ON = 1,
  SI_SYNC_BUTTON_STATE_DISABLED = 2,
} SiSyncButtonState;

#endif   /* _SI_SYNC_H_ */
