﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Framework.TimeSliceTool
{
    /// <summary>
    /// 主视图模型
    /// </summary>
    public class MainViewModel : ViewModelBase
    {
        public MainViewModel()
        {
            this.SelectDirPathCommand = new VCommand(this.SelectDirPath);
        }

        // ------------------------------------------------------------------------
        // Property 
        // ------------------------------------------------------------------------

        #region DirPath -- 文件夹路径

        private string dirPath;
        /// <summary>
        /// 文件夹路径
        /// </summary>
        public string DirPath
        {
            get { return dirPath; }
            set { dirPath = value; this.RaisePropertyChanged(nameof(DirPath)); }
        }

        #endregion

        #region JsonString -- Json字符串

        private string jsonString;
        /// <summary>
        /// Json字符串
        /// </summary>
        public string JsonString
        {
            get { return jsonString; }
            set { jsonString = value; this.RaisePropertyChanged(nameof(JsonString)); }
        }

        #endregion

        // ------------------------------------------------------------------------
        // Command 
        // ------------------------------------------------------------------------

        #region SelectDirPathCommand -- 选择文件夹路径命令

        /// <summary>
        /// 选择文件夹路径命令
        /// </summary>
        public VCommand SelectDirPathCommand { get; set; }

        /// <summary>
        /// 选择文件夹路径
        /// </summary>
        private void SelectDirPath()
        {

            System.Windows.Forms.FolderBrowserDialog dialog = new System.Windows.Forms.FolderBrowserDialog();
            if (dialog.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            this.DirPath = dialog.SelectedPath;
        }

        #endregion

        #region SendCommand -- 发送命令



        #endregion
    }
}
