﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 跟踪框扩展
    /// </summary>
    public static class TrackingBoxExpand
    {
        /// <summary>
        /// 更新跟踪框
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="trackingBoxInfos">跟踪框信息</param>
        public static void UpdateTrackingBox(this VideoControl videoControl, List<TrackingBoxInfo> trackingBoxInfos)
        {
            if (videoControl.videoRender == null)
                return;

            TrackingBoxPlugin plugin = videoControl.GetPlugin<TrackingBoxPlugin>(VideoControlPluginNames.TrackingBox);
            if (plugin == null)
                return;

            plugin.Update(trackingBoxInfos);
        }

        /// <summary>
        /// 清理跟踪框
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public static void ClearTrackingBox(this VideoControl videoControl)
        {
            if (videoControl.videoRender == null)
                return;

            TrackingBoxPlugin plugin = videoControl.GetPlugin<TrackingBoxPlugin>(VideoControlPluginNames.TrackingBox);
            if (plugin == null)
                return;

            plugin.Update(null);
        }

        /// <summary>
        /// 命中测试
        /// </summary>
        /// <param name="trackingBoxInfos">跟踪框信息结合</param>
        /// <param name="point">视频坐标</param>
        /// <returns>命中的跟踪框</returns>
        public static List<TrackingBoxInfo> HitTest(List<TrackingBoxInfo> trackingBoxInfos, System.Windows.Point point)
        {
            List<TrackingBoxInfo> result = new List<TrackingBoxInfo>();

            if (trackingBoxInfos == null || trackingBoxInfos.Count == 0)
                return result;

            foreach (TrackingBoxInfo item in trackingBoxInfos)
            {
                if (point.X >= item.SrcRect.Left && point.X <= item.SrcRect.Right && point.Y >= item.SrcRect.Top && point.Y <= item.SrcRect.Bottom)
                {
                    result.Add(item);
                }
            }

            return result;
        }
    }
}
