﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// OpenCV流任务基类
    /// </summary>
    public abstract class OpenCVStreamTaskBase : VideoStreamTaskBase
    {
        /// <summary>
        /// OpenCV工具任务基类
        /// </summary>
        /// <param name="stream">OpenCV流</param>
        public OpenCVStreamTaskBase(OpenCVStream stream)
        {
            this.Stream = stream;
        }

        /// <summary>
        /// 任务名称
        /// </summary>
        public abstract OpenCVStreamTaskNames Name { get; }

        /// <summary>
        /// OpenCV流
        /// </summary>
        public OpenCVStream Stream { get; private set; }
    }
}