﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 调试面板
    /// </summary>
    public class DebugBorder : Border
    {
        public DebugBorder()
        {
            this.Loaded += DebugBorder_Loaded;
        }

        /// <summary>
        /// 是否已经完成加载
        /// </summary>
        private bool isAlreadyLoaded = false;

        private void DebugBorder_Loaded(object sender, System.Windows.RoutedEventArgs e)
        {
            if (WPFHelper.IsInDesignMode(this))
                return;

            if (this.isAlreadyLoaded)
                return;

            this.Visibility = ApplicationDomain.IS_DEBUG ? System.Windows.Visibility.Visible : System.Windows.Visibility.Hidden;

            this.isAlreadyLoaded = true;
        }
    }
}
