﻿using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 图片辅助类扩展
    /// </summary>
    public static class ImageHelperExpand
    {
        /// <summary>
        /// 将RawRectangleF转化为Rect
        /// </summary>
        /// <param name="rect">RawRectangleF</param>
        /// <returns>Rect</returns>
        public static Rect ToRect(this RawRectangleF rect)
        {
            return new Rect(rect.Left, rect.Top, rect.Right - rect.Left, rect.Bottom - rect.Top);
        }

        /// <summary>
        /// 将Rect转化为RawRectangleF
        /// </summary>
        /// <param name="rect">Rect</param>
        /// <returns>RawRectangleF</returns>
        public static RawRectangleF ToRawRectangleF(this Rect rect)
        {
            return new RawRectangleF((float)rect.Left, (float)rect.Top, (float)rect.Right, (float)rect.Bottom);
        }
    }
}
