﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// GPI设备USB驱动 信息
    /// </summary>
    public struct GPI_USB_DEVICE_INFO
    {
        /// <summary>
        /// 固件名称字符串
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public Byte[] FirmwareName;

        /// <summary>
        /// 固件编译时间字符串
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public Byte[] BuildDate;

        /// <summary>
        /// 硬件版本号
        /// </summary>
        public UInt32 HardwareVersion;

        /// <summary>
        /// 固件版本号
        /// </summary>
        public UInt32 FirmwareVersion;

        /// <summary>
        /// 适配器序列号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
        public UInt32[] SerialNumber;

        /// <summary>
        /// 适配器当前具备的功能
        /// </summary>
        public UInt32 Functions;
    }

    /// <summary>
    /// GPI设备USB驱动
    /// </summary>
    public static class GPI_USB_DEVICE
    {
        /// <summary>
        /// 定义电压输出值 -- 不输出
        /// </summary>
        public const Byte POWER_LEVEL_NONE = 0;

        /// <summary>
        /// 定义电压输出值 -- 输出1.8V
        /// </summary>
        public const Byte POWER_LEVEL_1V8 = 1;

        /// <summary>
        /// 定义电压输出值 -- 输出2.5V
        /// </summary>
        public const Byte POWER_LEVEL_2V5 = 2;

        /// <summary>
        /// 定义电压输出值 -- 输出3.3V
        /// </summary>
        public const Byte POWER_LEVEL_3V3 = 3;

        /// <summary>
        /// 定义电压输出值 -- 输出5.0V
        /// </summary>
        public const Byte POWER_LEVEL_5V0 = 4;

        /// <summary>
        /// 初始化USB设备，并扫描设备连接数，必须调用
        /// </summary>
        /// <param name="pDevHandle">每个设备的设备号存储地址</param>
        /// <returns>扫描到的设备数量</returns>
        [DllImport("USB2XXX.dll")]
        public static extern Int32 USB_ScanDevice(IntPtr[] pDevHandle);

        /// <summary>
        /// 打开设备，必须调用
        /// </summary>
        /// <param name="DevHandle">设备索引号</param>
        /// <returns>打开设备的状态</returns>
        [DllImport("USB2XXX.dll")]
        public static extern bool USB_OpenDevice(IntPtr DevHandle);

        /// <summary>
        /// 关闭设备，必须调用
        /// </summary>
        /// <param name="DevHandle">设备索引号</param>
        /// <returns>打开设备的状态</returns>
        [DllImport("USB2XXX.dll")]
        public static extern bool USB_CloseDevice(IntPtr DevHandle);

        /// <summary>
        /// 复位设备程序，复位后需要重新调用USB_ScanDevice，USB_OpenDevice函数
        /// </summary>
        /// <param name="DevHandle">设备索引号</param>
        /// <returns>复位设备的状态</returns>
        [DllImport("USB2XXX.dll")]
        public static extern bool USB_ResetDevice(IntPtr DevHandle);

        /// <summary>
        /// 获取设备信息，比如设备名称，固件版本号，设备序号，设备功能说明字符串等
        /// </summary>
        /// <param name="DevHandle">设备索引号</param>
        /// <param name="pDevInfo">设备信息存储结构体指针</param>
        /// <param name="pFunctionStr">设备功能说明字符串</param>
        /// <returns>获取设备信息的状态</returns>
        [DllImport("USB2XXX.dll")]
        public static extern bool DEV_GetDeviceInfo(IntPtr DevHandle, ref GPI_USB_DEVICE_INFO pDevInfo, StringBuilder pFunctionStr);

        /// <summary>
        /// 设置可变电压输出引脚输出电压值
        /// </summary>
        /// <param name="DevHandle">设备索引号</param>
        /// <param name="PowerLevel">输出电压值</param>
        /// <returns>设置输出电压状态</returns>
        [DllImport("USB2XXX.dll")]
        public static extern bool DEV_SetPowerLevel(IntPtr DevHandle, byte PowerLevel);
    }
}
