﻿using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.UDPTestTool
{
    /// <summary>
    /// Excel 数据上下文
    /// </summary>
    public class ExcelContext
    {
        /// <summary>
        /// UDP信号信息
        /// </summary>
        public List<UdpSignalInfo> UdpSignalInfos { get; private set; }

        /// <summary>
        /// 加载UDP信号信息
        /// </summary>
        /// <param name="path">文件路径</param>
        public void LoadUdpSignalInfos(string path)
        {
            List<UdpSignalInfo> result = new List<UdpSignalInfo>();

            using (FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read))
            {
                IWorkbook workbook = new HSSFWorkbook(fs);

                ISheet sheet = workbook.GetSheet("Sheet1");

                for (int i = 1; i <= sheet.LastRowNum; i++)
                {
                    IRow row = sheet.GetRow(i);

                    UdpSignalInfo item = new UdpSignalInfo();

                    item.Label = row.GetCell(0)?.StringCellValue;
                    item.Json = row.GetCell(1)?.StringCellValue;

                    result.Add(item);
                }
            }

            this.UdpSignalInfos = result;
        }
    }
}
