import path from 'path'
import webpack from 'webpack'

module.exports = {
  mode: 'production',
  name: 'vendor',
  entry: ['react', 'react-dom', 'react-redux', 'react-router-dom'], // 这个例子我们打包 lodash 作为公共类库
  output: {
    path: path.resolve('dll'),
    filename: 'vendor.dll.js',
    library: 'vendor_[hash]' // 打包后对外暴露的类库名称
  },

  plugins: [
    new webpack.DllPlugin({
      name: 'vendor_[hash]',
      path: path.resolve('dll/vendor.manifest.json') // 使用 DLLPlugin 在打包的时候生成一个 manifest 文件
    })
  ]
}
