import React, { useMemo, useRef } from 'react'

import ProTable, { ActionType, ProTableProps } from '@ant-design/pro-table'

export function DTable<T, U, ValueType = 'text'> (props: ProTableProps<T, U, ValueType>) {
  return (
    <>
      <ProTable
        rowKey="id" // 表格单行使用那个字段作为唯一标识
        cardBordered={true}
        editable={{
          type: 'multiple'
        }}
        pagination={{ pageSize: 10 }}
        dateFormatter="string" // 时间格式设置
        options={{
          // 工具栏配置 不需要时直接为false即可
          fullScreen: false, // 全屏
          search: false, // 搜索
          setting: true, // 列设置
          reload: true, // 刷新
          density: true // 密度
        }}
        {...props}
      />
    </>
  )
}

export function usePTable<T = any, U = any, ValueType = 'text'> (options: ProTableProps<T, U, ValueType>) {
  const actionRef = useRef<ActionType>()

  const tableProps = useMemo(() => {
    return {
      actionRef,
      ...options
    }
  }, [options])

  return {
    tableProps,
    actionRef
  }
}
