import React, { useState } from 'react'

import { ProFormText } from '@ant-design/pro-form'
import styled from 'styled-components'

import { useAppSelector } from '@/hooks/useStore'

type TProps = {
  handleIconClick: (id: string) => void
}
const MyIcon = ({ handleIconClick }: TProps) => {
  const iconData = useAppSelector((state) => { return state.icon.iconData })
  const [isShowIcon, setIsShowIcon] = useState<boolean>(false)
  const [currentIcon, setCurrentIcon] = useState<string>('')

  const handleFocus = () => {
    // 获取焦点事件
    setIsShowIcon(true)
  }
  const handelBlur = () => {
    // 失去焦点事件
    setIsShowIcon(false)
  }
  // 图标点击事件
  const handleClick = (data: { font_class: string, icon_id: string }) => {
    handleIconClick(data.font_class)
    setCurrentIcon(data.icon_id)
    setIsShowIcon(false)
  }
  const handleMouseUp = (e: any) => {
    e.returnValue = true
  }
  const handleMouseDown = (e: any) => {
    e.preventDefault()
  }
  return (
    <MyIconLayout>
      <ProFormText
        width="md"
        name="icon"
        label="图标"
        fieldProps={{
          onFocus: handleFocus,
          onBlur: handelBlur
        }}
        placeholder="请选择图标"
      />
      {isShowIcon && (
        <div className="iconList">
          {iconData?.glyphs.map(item => {
            return (
              <div key={item.icon_id} onMouseUp={(e) => { handleMouseUp(e) }} onMouseDown={(e) => { handleMouseDown(e) }} onClick={() => handleClick(item)}>
                <span className={` ${item.icon_id === currentIcon ? 'icon' : ''} iconfont icon-package${item.font_class}`}></span>
              </div>
            )
          })}
        </div>
      )}
    </MyIconLayout>
  )
}

export default MyIcon

const MyIconLayout = styled.div`
  width: 100%;
  height: 100%;
  position: relative;
  ProFormText {
    width: 90%;
    margin: 10px auto;
    /* height: 10px; */
  }
  .iconList {
    display: flex;
    z-index: 1;
    text-align: center;
    overflow: hidden;
    ::-webkit-scrollbar {
      display: none;
    }
    overflow-y: auto;
    background: #fff;
    position: absolute;
    top: 80px;
    width: 90%;
    height: 456px;
    border: 1px solid #ebeef5;
    box-shadow: 0 2px 12px 0 rgb(0 0 0 / 10%);
    align-items: center;
    justify-content: center;
    flex-wrap: wrap;
    > div {
      width: 40px;
      height: 40px;
      line-height: 40px;
      margin: 10px;
      border: 1px #ccc solid;
      text-align: center;
      > span {
        font-size: 30px;
      }
      .icon{
        color: #3a8ee6;
      }
    }
  }
`
