import React, { Suspense } from 'react'
import { Outlet } from 'react-router-dom'

import styled from 'styled-components'

import { Layout, Spin } from 'antd'

import { useAppSelector } from '@/hooks/useStore'

import LayoutHeader from './Header/index'
import LayoutMenu from './Menu/index'
const { Content, Sider } = Layout

const App = () => {
  const isCollapse = useAppSelector(state => state.menu.isCollapse)
  return (
    <Layout>
      <Sider trigger={null} collapsed={isCollapse} width={220} theme="light">
        <LayoutMenu />
      </Sider>
      <Layout style={{ minHeight: '100vh' }}>
        <LayoutHeader />
        <DLayout>
          <DContent>
            <Suspense
              fallback={
                <Spin
                  size="large"
                  style={{
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    height: '100%'
                  }}
                />
              }>
              <Outlet />
            </Suspense>
          </DContent>
        </DLayout>
      </Layout>
    </Layout>
  )
}

export default App

const DContent = styled(Content)`
  /* background: #fff; */
  /* padding: 16px; */
  margin: 0;
  min-height: 280px;
`
const DLayout = styled(Layout)`
  padding: 16px 20px 0;
  /* min-height: calc(100vh - 55px); */
`
