import { Link, useLocation } from 'react-router-dom'

import { Breadcrumb } from 'antd'

import { HOME_URL } from '@/config/config'
import { useAppSelector } from '@/hooks/useStore'

const BreadcrumbNav = (props: any) => {
  const breadcrumb = useAppSelector(state => state.breadcrumb)
  const { pathname } = useLocation()
  const breadcrumbList = breadcrumb.breadcrumbList[pathname] || []

  return (
    <Breadcrumb>
      <Breadcrumb.Item>
        <Link to={HOME_URL}>首页</Link>
      </Breadcrumb.Item>
      {breadcrumbList.map((item: string) => {
        return <Breadcrumb.Item key={item}>{item !== '首页' ? item : null}</Breadcrumb.Item>
      })}
    </Breadcrumb>
  )
}

export default BreadcrumbNav
