import { MenuFoldOutlined, MenuUnfoldOutlined } from '@ant-design/icons'

import { useAppDispatch, useAppSelector } from '@/hooks/useStore'
import { setIsCollapse } from '@/store/menu'

const CollapseIcon = () => {
  const isCollapse = useAppSelector(state => state.menu.isCollapse)
  const dispatch = useAppDispatch()
  return (
    <div
      className="collapsed"
      onClick={() => {
        dispatch(setIsCollapse(!isCollapse))
      }}>
      {isCollapse ? <MenuUnfoldOutlined /> : <MenuFoldOutlined />}
    </div>
  )
}

export default CollapseIcon
