import React, { useCallback, useEffect, useState } from 'react'

import { ModalForm, ProFormSelect, ProFormSwitch, ProFormText } from '@ant-design/pro-form'

import { message } from 'antd'

import { TUpdate } from '@/typings/account'

import { AddApi, GetDetailApi, GetRoleApi, UpdateApi } from '../common/services'

type TProps = {
  visible: boolean;
  id: number;
  handleUpdateVisible: (value: boolean, type: string) => void;
};

const Add = ({ visible, id, handleUpdateVisible }: TProps) => {
  const [title, setTitle] = useState<string>('')
  const [roleData, setRoleData] = useState<any[]>([])

  useEffect(() => {
    getRole()
    if (id) {
      setTitle('编辑账号')
      return
    }
    setTitle('创建账号')
  }, [visible])

  const getRole = useCallback(async () => {
    const arr:any = []
    try {
      const { data } = await GetRoleApi()
      console.log(data)
      for (let i = 0; i < data.length; i++) {
        arr.push({
          label: data[i].name,
          value: data[i].id
        })
      }
      setRoleData(arr)
    } catch (error) {
      console.log(error)
    }
  }, [id])

  const fetchDetail = useCallback(async () => {
    let data: any = {
      username: '', // 角色名称
      password: '', // 密码
      realName: '', // 昵称
      status: null, // 状态
      roleIdList: [] // 角色列表
    }
    if (id) {
      try {
        const res = await GetDetailApi(id)
        if (res.code !== 0) return
        const status = !!res?.data?.status
        res.data.status = status
        data = res?.data
      } catch (error) {
        console.log(error)
      }
    }
    data.roleIdList = data.roleIdList?.[0]
    return data
  }, [id])

  const cancelClick = () => {
    handleUpdateVisible(false, '')
  }
  const okClick = async (values: any) => {
    const params:any = {
      username: values?.username, // 角色名称
      password: values?.password, // 密码
      realName: values?.realName, // 昵称
      roleIdList: [values?.roleIdList], // 角色列表
      status: Number(values?.status)
    }
    try {
      if (id) {
        params.id = id
      }
      const { code } = id ? await UpdateApi(params) : await AddApi(params)
      code === 0 ? message.success('编辑成功') : message.success('创建成功')
      handleUpdateVisible(false, 'add')
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <ModalForm<TUpdate>
      title={title}
      visible={visible}
      autoFocusFirstInput
      modalProps={{
        onCancel: cancelClick,
        destroyOnClose: true
      }}
      onFinish={async (e) => {
        okClick(e)
      }}
      request={fetchDetail}
    // layout="horizontal"
    >
      <ProFormText width="md" name="username" label="账号" placeholder="请输入账号名称" rules={[{ required: true, message: '请输入账号名称' }]}
      />
      {!id && (<ProFormText width="md" name="password" label="密码" placeholder="请输入账号密码" rules={[{ required: true, message: '请输入账号密码' }]} />)}
      <ProFormText width="md" name="realName" label="昵称" placeholder="请输入账号昵称" />
      <ProFormSwitch name="status" label="状态" />
      <ProFormSelect width="md" name="roleIdList" label="角色" options={roleData} placeholder="请选择角色"
      />
    </ModalForm>
  )
}
export default Add
