import React, { useCallback, useState } from 'react'

import { Button, message, Popconfirm, Space } from 'antd'

import { DList } from '@/components/DList'
import { DTable, usePTable } from '@/components/DTable'
// import { useAppSelector } from '@/hooks/useStore'

import { DelApi, GetListByPageApi } from './common/services'
import { TState } from './common/typing'
import Edit from './components/addUpdate'

const Interact = () => {
  const [dataSource, setDataSource] = useState<TState[]>([])
  const [currentId, setCurrentId] = useState<number>(NaN)
  const [isModalVisible, setIsModalVisible] = useState<boolean>(false)
  const { tableProps, actionRef } = usePTable<TState>({
    headerTitle: '互动模块列表',
    request: useCallback(async (params: any) => {
      const result = {
        data: [
          {
            id: 1,
            studioName: '发电时刻',
            studioId: '发电时刻描述'
          },
          {
            id: 2,
            studioName: '选帖上暂停',
            studioId: '选帖上暂停描述'
          },
          {
            id: 3,
            studioName: '球员评分',
            studioId: '球员评分描述'
          }
        ],
        total: 1,
        success: true
      }
      try {
        const { pageSize, current: pageNum, studioName } = params
        const { data } = await GetListByPageApi({
          pageBean: {
            pageNum,
            pageSize
          },
          studioName
        })
        const { list, total } = data

        setDataSource(list)
        // result.data = list
        result.total = total
      } catch (error) {
        console.error('请求列表失败', error)
      }
      return result
    }, []),
    columns: [
      {
        title: 'ID',
        dataIndex: 'id',
        width: 100,
        copyable: true,
        hideInSearch: true
      },
      {
        title: '模块名称',
        key: 'studioName',
        dataIndex: 'studioName',
        hideInSearch: false
      },
      {
        title: '模块描述',
        key: 'studioId',
        dataIndex: 'studioId',
        hideInSearch: true
      },
      // {
      //   title: '类型',
      //   key: 'ip1',
      //   dataIndex: 'ip1',
      //   hideInSearch: true,
      //   render: (text, record) => [
      //     <span key='primaryService'>{record?.ip1}:{record?.port1}</span>
      //   ]
      // },
      // {
      //   title: '所关联互动模块',
      //   key: 'ip2',
      //   dataIndex: 'ip2',
      //   hideInSearch: true,
      //   render: (text, record) => [
      //     <span key='primaryService'>{record?.ip2}:{record?.port2}</span>
      //   ]
      // },
      {
        title: '创建时间',
        key: 'create_time',
        dataIndex: 'create_time',
        valueType: 'dateTime',
        hideInSearch: true
      },
      {
        title: '修改时间',
        key: 'update_time',
        dataIndex: 'update_time',
        valueType: 'dateTime',
        hideInSearch: true
      },
      {
        title: '操作',
        valueType: 'option',
        render: (text, record) => [
          <Space key="option" size={20}>
            <a key="editable">
              编辑
            </a>
            <Popconfirm
              title="确认删除该条数据？"
              onConfirm={() => handleClickOperation('Del', record)}
              okText="Yes"
              cancelText='No'>
              <a key="delete">
                删除
              </a>
            </Popconfirm>
          </Space>
        ]
      }
    ],
    toolBarRender: useCallback(() => [
      <Button key='tool' type="primary" onClick={() => handleUpdateVisible(true, '')} >
        创建模块
      </Button>
    ], [])
  })
  const handleClickOperation = useCallback( // 表格操作
    async (type: 'Edit' | 'Del', record: TState) => {
      switch (type) {
        case 'Edit':
          setIsModalVisible(true)
          setCurrentId(record.id)
          break
        case 'Del':
          try {
            const { status } = await DelApi({ id: record.id })
            if (status !== 200) {
              message.error('删除失败')
              return
            }
            message.success('删除成功')
            dataSource.length <= 1 ? actionRef.current?.reloadAndRest?.() : actionRef.current?.reload?.()
          } catch (error) {
            console.log(error)
            message.error('删除失败')
          }
          break
      }
    }, [dataSource])
  const handleUpdateVisible = (value: boolean, type: string) => {
    setIsModalVisible(value)
    if (!value) {
      setCurrentId(NaN)
    }
    if (type === 'add') {
      (actionRef.current as any).reload()
    }
  }
  return (
    <>
      <DList>
        <DTable {...tableProps} />
      </DList>
      <Edit visible={isModalVisible} handleUpdateVisible={handleUpdateVisible} id={currentId} />
    </>
  )
}
export default Interact
