import { Get, Post } from '@/utils/request'

import { TInteractList, TInteractUpdate } from './typing'

/**
 * @description 列表查询
 */
export const GetListByPageApi = (params: TInteractList): Promise<any> => {
  return Post('/studio/list', { params })
}
/**
 * @description 删除
 */
export const DelApi = (params:{}): Promise<any> => {
  return Post('/type/del', { params })
}
/**
 * @description 修改
 */
export const UpdateApi = (params: Partial<TInteractUpdate>): Promise<any> => {
  return Post('/type/update', { params })
}

/**
 * @description 添加
 */
export const AddApi = (params: Partial<TInteractUpdate>): Promise<any> => {
  return Post('/type/add', { params })
}
/**
 * @description 详情
 */
export const GetDetailApi = (id: number): Promise<any> => {
  return Get(`/hzy-admin/sys/user/${id}`)
}
