import React, { useCallback, useEffect, useMemo, useRef, useState } from 'react'

import { ProCard, ProFormInstance } from '@ant-design/pro-components'

// import { message } from 'antd'

// import { useAppSelector } from '@/hooks/useStore'

import { Button, message } from 'antd'

import { DelApi, GetListByPageApi, UpdateApi } from './common/services'
import { TState } from './common/typing'
import AddUpdate from './components/addUpdate'
import DForm from './components/DForm'

const Studio = () => {
  const [tab, setTab] = useState('')
  const formRef = useRef<ProFormInstance>()
  const [dataSource, setDataSource] = useState<TState[]>([])
  const [isModalVisible, setIsModalVisible] = useState<boolean>(false)

  useEffect(() => {
    getData()
  }, [])

  const getData = async () => { // 演播室数据
    const { data } = await GetListByPageApi({
      pageBean: {
        pageNum: 0,
        pageSize: 0
      }
    })
    setTab(String(data?.list[0].id))
    setDataSource(data?.list)
  }
  const handleClickOperation = useCallback( // 操作
    async (type: 'Edit' | 'Del', record: any) => {
      switch (type) {
        case 'Edit':
          try {
            const params = {
              id: Number(tab),
              ...record
            }
            const { status } = await UpdateApi(params)
            if (status !== 200) {
              message.error('编辑失败')
              return
            }
            message.success('编辑成功')
            getData()
          } catch (error) {
            console.log(error)
            message.error('编辑失败')
          }
          break
        case 'Del':
          try {
            const { status } = await DelApi({ id: record.id })
            if (status !== 200) {
              message.error('删除失败')
              return
            }
            message.success('删除成功')
            getData()
          } catch (error) {
            console.log(error)
            message.error('删除失败')
          }
          break
      }
    }, [dataSource])
  const handleUpdateVisible = (value: boolean, type: string) => { // 弹窗状态
    setIsModalVisible(value)
    type === 'Add' && getData()
  }
  const data = useMemo(() => {
    return dataSource.map((item) => <ProCard.TabPane key={String(item.id)} tab={item?.studioName}>
      <DForm
        formRef={formRef}
        autoFocusFirstInput
        submitter={{
          searchConfig: {
            submitText: '保存'
          },
          resetButtonProps: { // 配置按钮的属性
            style: {
              display: 'none' // 隐藏重置按钮
            }
          },
          render: (props: any, doms: any) => {
            return [
              ...doms,
              <Button type="primary" key='delete' danger onClick={() => handleClickOperation('Del', item)}>删除</Button>
            ]
          }
        }}
        request={() => { return item }}
        onReset={() => {
          console.log('重置')
        }}
        onFinish={(values: any) => handleClickOperation('Edit', values)}
      />
    </ProCard.TabPane>)
  }, [dataSource])

  return (
    <>
      <ProCard
        tabs={{
          type: 'card',
          tabPosition: 'top',
          activeKey: tab,
          onChange: (key: any) => {
            setTab(key)
          }
        }}
        extra={<Button type="primary" onClick={() => handleUpdateVisible(true, '')}>新增</Button>}
      >
        {data}
      </ProCard>
      <AddUpdate visible={isModalVisible} handleUpdateVisible={handleUpdateVisible} />
    </>
  )
}
export default Studio
