export type TStudioList = {
  id?: number,
  pageBean:{
    pageNum: number // 当前页码，从1开始
    pageSize:number // 每页显示记录数
  },
  // studioName: string // 演播室名称
  // limit: number // 每页显示记录数
  // page: number // 当前页码，从1开始
  // order: string // 排序方式，可选值(asc、desc)
  // orderField: string // 排序字段
  // username: string // 用户名
}

export type TStudioUpdate = {
  studioName: string // 演播室名称
  studioId: string // 演播室id
  ip1: string // 主服务ip
  ip2: string // 备服务ip
  port1: string // 主服务器端口
  port2: string // 备服务器端口
  sceneNameS: string // 主场景地址
  sceneNameQ: string // 备场景地址
  createTime: string // 创建时间
  updateTime: string // 修改时间
  type:string // 弹幕类型 1.入库并存为TXT,2.只保存txt,3.发送tcp并存为txt
  intervalTime: number // 弹幕轮询时间间隔
  bulletChatNums: number // 筛选弹幕限制数量
  powerTime: number // 发电时刻开启服务时，默认时间间隔
  id: number
}

export type TState = TStudioUpdate
