module.exports = {
  env: {
    browser: true,
    es2021: true
  },
  extends: [
    'plugin:react/recommended',
    'standard'
  ],
  parser: '@typescript-eslint/parser',
  parserOptions: {
    ecmaFeatures: {
      jsx: true
    },
    ecmaVersion: 'latest',
    sourceType: 'module'
  },
  plugins: [
    'react',
    '@typescript-eslint',
    'eslint-plugin-import-helpers'
  ],
  rules: {
    'import-helpers/order-imports': [
      'error',
      { // example configuration
        newlinesBetween: 'always',
        groups: [
          '/^react/',
          'module',
          '/antd/',
          '/^@//',
          'absolute'
        ],
        alphabetize: { order: 'asc', ignoreCase: true }
      }
    ],
    'react/jsx-uses-react': 'off',
    'react/react-in-jsx-scope': 'off',
    'no-fallthrough': 'off',
    'no-debugger': 'off'
  }
}
