// import webpack from 'webpack'
import path from 'path'
import UnusedWebpackPlugin from 'unused-webpack-plugin'
import merge from 'webpack-merge'

import BaseConfig from './webpack.base.config'

const DevConfig = merge(BaseConfig, {
  mode: 'development',
  devtool: 'eval',
  output: {
    filename: '[name].bundle.js',
    pathinfo: false
  },
  devServer: {
    hot: true,
    open: true,
    // host: HOST,
    // stats: 'errors-warnings',
    compress: false,
    historyApiFallback: true
  },
  // plugins: [new webpack.HotModuleReplacementPlugin()],
  plugins: [
    new UnusedWebpackPlugin({
      directories: [path.join(__dirname, 'src')],
      root: path.join(__dirname, '../')
    })
  ]
} as any)

module.exports = DevConfig
