import { useState } from 'react'
import { useNavigate } from 'react-router-dom'

import { ExclamationCircleOutlined } from '@ant-design/icons'

import { Avatar, Modal, Menu, Dropdown, message } from 'antd'

import { HOME_URL } from '@/config/config'
import { useAppDispatch } from '@/hooks/useStore'
import { setLogin } from '@/store/user'

import UserPassword from './update-password'

const AvatarIcon = () => {
  const dispatch = useAppDispatch()
  const navigate = useNavigate()
  const [passwordVisible, setPasswordVisible] = useState(false)

  // 退出登录
  const logout = () => {
    Modal.confirm({
      title: '温馨提示 🧡',
      icon: <ExclamationCircleOutlined />,
      content: '是否确认退出登录？',
      okText: '确认',
      cancelText: '取消',
      onOk: () => {
        dispatch(setLogin({}))
        message.success('退出登录成功！')
        navigate('/login')
      }
    })
  }
  // 修改密码
  const handlePassword = () => {
    setPasswordVisible(true)
  }
  const handleUpdatePassword = (value:boolean) => {
    setPasswordVisible(value)
  }

  // Dropdown Menu
  const menu = (
    <Menu
      items={[
        {
          key: '1',
          label: <span className="dropdown-item">首页</span>,
          onClick: () => navigate(HOME_URL)
        },
        // {
        //   key: '2',
        //   label: <span className="dropdown-item">个人信息</span>,
        //   onClick: () => infoRef.current!.showModal({ name: 11 })
        // },
        {
          key: '3',
          label: <span className="dropdown-item">修改密码</span>,
          onClick: handlePassword
        },
        {
          type: 'divider'
        },
        {
          key: '4',
          label: <span className="dropdown-item">退出登录</span>,
          onClick: logout
        }
      ]}></Menu>
  )
  return (
    <>
      <Dropdown overlay={menu} placement="bottom" arrow trigger={['click']}>
        <Avatar src="https://lf1-xgcdn-tos.pstatp.com/obj/vcloud/vadmin/start.8e0e4855ee346a46ccff8ff3e24db27b.png" />
      </Dropdown>
      <UserPassword
        handleUpdatePassword={handleUpdatePassword}
        visible={passwordVisible}></UserPassword>
    </>
  )
}

export default AvatarIcon
