import styled from 'styled-components'

import { Layout } from 'antd'

import { useAppSelector } from '@/hooks/useStore'

import AvatarIcon from './components/AvatarIcon'
import BreadcrumbNav from './components/BreadcrumbNav'
import CollapseIcon from './components/CollapseIcon'
const { Header } = Layout
const LayoutHeader = () => {
  const { username } = useAppSelector(({ user }) => (user))
  return (
    <DHeader>
      <div className="header-lf">
        <CollapseIcon />
        <BreadcrumbNav />
      </div>
      <div className="header-ri">
        <span className="username">{username}</span>
        <AvatarIcon />
      </div>
    </DHeader>
  )
}
const DHeader = styled(Header)`
  display: flex;
  align-items: center;
  justify-content: space-between;
  height: 55px;
  padding: 0 40px 0 20px;
  background-color: #ffffff;
  border-bottom: 1px solid #e5e6eb;
  .header-lf {
    display: flex;
    align-items: center;
    .collapsed {
      margin-right: 20px;
      font-size: 18px;
      cursor: pointer;
      transition: color 0.3s;
    }
  }
  .header-ri {
    display: flex;
    align-items: center;
    .icon-style {
      margin-right: 22px;
      font-size: 19px;
      line-height: 19px;
      color: rgb(77 77 77);
      cursor: pointer;
    }
    .username {
      margin: 0 20px 0 0;
      font-size: 15px;
      color: #000000;
    }
    .ant-avatar {
      cursor: pointer;
    }
  }
`

export default LayoutHeader
