import React, { useEffect, useState } from 'react'
import { useLocation, useNavigate } from 'react-router-dom'

import styled from 'styled-components'

import { Menu, MenuProps, Spin } from 'antd'
import { ItemType } from 'antd/lib/menu/hooks/useItems'

import { useAppSelector, useAppDispatch } from '@/hooks/useStore'
import { setBreadcrumbList } from '@/store/breadcrumb'
import { getPermissions, setMenuListData } from '@/store/menu'
import { setAuthRouter } from '@/store/user'
import { findAllBreadcrumb, getOpenKeys, handleRouter, searchRoute } from '@/utils/utils'

import Logo from './components/Logo'
// import { MenuNavApi } from './services/menu'

type MenuItem = Required<MenuProps>['items'][number]

const LayoutMenu = () => {
  const isCollapse = useAppSelector(state => state.menu.isCollapse)
  const menuStore = useAppSelector(state => state.menu)
  const dispatch = useAppDispatch()

  const loopMenuItem = (menus: any): ItemType[] => {
    return menus.map(
      (item: {
        label: React.ReactNode
        key: React.Key
        path: any
        icon?: any
        children?: MenuItem[]
        type?: string
        hidden?: boolean
      }) => {
        return {
          key: item.path,
          label: item.label,
          icon: (<span className={item.icon}></span>),
          children: item.children && loopMenuItem(item.children),
          type: item.type || '',
          hidden: item.hidden || false
        }
      }
    )
  }
  const navigate = useNavigate()
  const [loading, setLoading] = useState(false)
  const { pathname } = useLocation()
  const [selectedKeys, setSelectedKeys] = useState<string[]>([pathname])
  const [openKeys, setOpenKeys] = useState<string[]>([])
  const [initListData, setInitListData] = useState<any[]>([])
  const [menuList, setMenuList] = useState<MenuItem[]>([]) // 获取菜单列表并处理成 antd menu 需要的格式

  const defaultMenus = [
    {
      path: '/home',
      label: '首页'
    },
    {
      path: '/studio',
      label: '演播室管理'
    },
    {
      path: '/match',
      label: '赛事管理'
    }
  ]

  // 初始化菜单列表
  const initList = async () => {
    // const { data } = await MenuNavApi()
    // setInitListData(handleDeepList(data))
    setInitListData(defaultMenus)
  }

  // const handleDeepList = (data: any[]): any => {
  //   if (!data.length) {
  //     return null
  //   }
  //   const newData: any[] = []
  //   for (let index = 0; index < data.length; index++) {
  //     const element = data[index]
  //     const tempMenuItem = {
  //       path: element.url,
  //       label: element.name,
  //       icon: `iconfont ${element.icon}`,
  //       children: handleDeepList(element.children)
  //     }

  //     if (data[index].type === 0) {
  //       if (Array.isArray(tempMenuItem.children)) {
  //         tempMenuItem.children = tempMenuItem.children.length ? tempMenuItem.children : null
  //       }
  //       newData.push(tempMenuItem)
  //     }
  //   }
  //   return newData
  // }
  // 设置当前展开的 subMenu
  const onOpenChange = (openKeys: string[]) => {
    if (openKeys.length === 0 || openKeys.length === 1) return setOpenKeys(openKeys)
    const latestOpenKey = openKeys[openKeys.length - 1]
    if (latestOpenKey.includes(openKeys[0])) return setOpenKeys(openKeys)
    setOpenKeys([latestOpenKey])
  }

  // 刷新高亮
  useEffect(() => {
    setSelectedKeys([pathname])
    !isCollapse && setOpenKeys(getOpenKeys(pathname))
  }, [pathname, isCollapse])

  // 获取动态MenuList
  useEffect(() => {
    initList()
    dispatch(getPermissions())
    setLoading(true)
    // 存储处理过后的所有面包屑导航栏到 redux 中
  }, [])
  useEffect(() => {
    if (initListData.length) {
      dispatch(setBreadcrumbList(findAllBreadcrumb(initListData)))
      setTimeout(() => {
        setMenuList(loopMenuItem(initListData))
        // 收起侧边栏 不展示subMenu
        setLoading(false)
        console.log('[ loading ]', loading)
      }, 100)
      // 把路由菜单处理成一维数组，存储到 redux 中，做菜单权限判断
      const dynamicRouter = handleRouter(initListData)
      dispatch(setAuthRouter(dynamicRouter))
      // getMenuApi
      dispatch(setMenuListData(initListData))
    }
  }, [initListData])
  // 点击当前菜单跳转页面

  const clickMenu: MenuProps['onClick'] = ({ key }: { key: string }) => {
    const route = searchRoute(key, menuStore.menuListData)
    console.log('[ route ]', route, menuStore.menuListData)
    // if (route.isLink) window.open(route.isLink, '_blank')
    navigate(key)
  }

  return (
    <MenuWrap>
      <Spin spinning={loading} tip="Loading...">
        <Logo></Logo>
        <Menu
          theme="light"
          mode="inline"
          triggerSubMenuAction="click"
          openKeys={openKeys}
          selectedKeys={selectedKeys}
          items={menuList}
          onClick={clickMenu}
          onOpenChange={onOpenChange}
        />
      </Spin>
    </MenuWrap>
  )
}

const MenuWrap = styled.div`
  height: 100%;
  .ant-spin-nested-loading {
    height: 100%;
    .ant-spin-container {
      height: 100%;
    }
  }
`
export default LayoutMenu
