import { Get, TResult } from '@/utils/request'

const PATHS = {
  MENU_LIST: `${process.env.API_HOST}/hzy-admin/sys/menu/list`,
  MENU_NAV: `${process.env.API_HOST}/hzy-admin/sys/menu/nav`,
  MENU_PER: `${process.env.API_HOST}/hzy-admin/sys/menu/permissions`
}

/**
 * @description: 列表查询
 * @param {TLogin} params
 * @return {*}
 */
export const MenuListApi = (): TResult => {
  return Get(PATHS.MENU_LIST)
}

/**
 * @description: 菜单导航
 * @param {*} TResult
 * @return {*}
 */
export const MenuNavApi = (): TResult => {
  return Get(PATHS.MENU_NAV)
}
/**
 * @description: 按钮权限
 * @param {*} TResult
 * @return {*}
 */
export const MenuPerApi = (): TResult => {
  return Get(PATHS.MENU_PER)
}
