import { Delete, Get, Post, Put } from '@/utils/request'

import { TAccountList, TAccountUpdate } from './typing'

/**
 * @description 列表查询
 */
export const GetListByPageApi = (params: TAccountList): Promise<any> => {
  return Get('/hzy-admin/sys/user/page', { params })
}
/**
 * @description 删除
 */
export const DelApi = (params: number[]): Promise<any> => {
  return Delete('/hzy-admin/sys/user', { params })
}
/**
 * @description 修改
 */
export const UpdateApi = (params: Partial<TAccountUpdate>): Promise<any> => {
  return Put('/hzy-admin/sys/user', { params })
}

/**
 * @description 添加
 */
export const AddApi = (params: Partial<TAccountUpdate>): Promise<any> => {
  return Post('/hzy-admin/sys/user', { params })
}
/**
 * @description 详情
 */
export const GetDetailApi = (id: number): Promise<any> => {
  return Get(`/hzy-admin/sys/user/${id}`)
}

/**
 * @description 获取角色
 */
export const GetRoleApi = (): Promise<any> => {
  return Get('/hzy-admin/sys/role/list')
}
/**
 * @description 修改密码
 */
export const PasswordUpdateApi = (params: any): Promise<any> => {
  return Put('/hzy-admin/sys/user/update/password', { params })
}
