import { TLogin } from '@/typings/login'
import { Post, TResult } from '@/utils/request'

const PATHS = {
  LOGIN: `${process.env.API_HOST}/hzy-admin/login`
}

/**
 * 登录响应参数
 */
type LoginRes = { token: string }

/**
 * @description: 列表查询
 * @param {TLogin} params
 * @return {*}
 */
export const LoginApi = (params: TLogin): TResult<LoginRes> => {
  return Post(PATHS.LOGIN, { params })
}
