import React, { useState, useCallback, useEffect, useRef } from 'react'
import { useNavigate } from 'react-router-dom'

import { UserOutlined, LockOutlined, SafetyOutlined } from '@ant-design/icons'
import styled from 'styled-components'

import { Form, Input, Button, message, Space, Image } from 'antd'

import { useAppDispatch, useAppSelector } from '@/hooks/useStore'
import { setLogin } from '@/store/user'

import { LoginApi } from './common/services'

const LoginPage: React.FC = () => {
  const uuid = useRef('')
  const [captchaUrl, setCaptchaUrl] = useState<string>('')
  const [form] = Form.useForm()
  const dispatch = useAppDispatch()
  const user = useAppSelector(({ user }) => user)
  const navigate = useNavigate()
  const users: any = {}
  const INIT_DATA = users.remember
    ? users
    : {
        username: 'admin',
        password: 'admin',
        remember: false
      }

  useEffect(() => {
    getCaptcha()
  }, [])

  // 获取uuid 验证码
  const getCaptcha = () => {
    const s: any = []
    const hexDigits = '0123456789abcdef'
    for (let i = 0; i < 36; i++) {
      s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1)
    }
    s[14] = '4' // bits 12-15 of the time_hi_and_version field to 0010
    s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1) // bits 6-7 of the clock_seq_hi_and_reserved to 01
    s[8] = s[13] = s[18] = s[23] = '-'
    const _uuid = s.join('')
    uuid.current = _uuid
    setCaptchaUrl(`${process.env.API_HOST}/hzy-admin/captcha?uuid=${_uuid}`)
  }
  const handleClickLogin = useCallback(async ({ remember, captcha, password, username }) => {
    try {
      // const data = await dispatch(
      //   loginAsync({
      //     username,
      //     password,
      //     captcha,
      //     uuid: uuid.current,
      //     grant_type: 'password'
      //   })
      // )
      // console.log('[ data ]', data)
      // if (data.payload && data.payload.code === 0) {
      //   navigate('/home')
      // } else {
      //   message.error(data.payload.msg)
      //   getCaptcha()
      // }
      const params = {
        username,
        password,
        captcha,
        uuid: uuid.current,
        grant_type: 'password'
      }
      const { data, code, msg } = await LoginApi(params)

      if (code === 0) {
        getCaptcha()
        dispatch(setLogin(data))
        navigate('/home')
      } else {
        msg && message.error(msg)
        getCaptcha()
      }
    } catch (e: any) {
      getCaptcha()
      console.error(e)
    }
  }, [])

  return (
    <LoginLayout>
      <LoginContainer>
        <LoginFromWarp className="login__warp">
          <LoginContainerHeader>配置管理后台</LoginContainerHeader>
          <Form form={form} initialValues={INIT_DATA} name="login__form" onFinish={handleClickLogin}>
            <Form.Item name="username" rules={[{ required: true, message: '请输入账号' }]}>
              <Input prefix={<UserOutlined className="site-form-item-icon" />} size="large" placeholder="账号" />
            </Form.Item>
            <Form.Item name="password" rules={[{ required: true, message: '请输入密码' }]}>
              <Input.Password
                prefix={<LockOutlined className="site-form-item-icon" />}
                size="large"
                type="password"
                placeholder="密码"
              />
            </Form.Item>
            <Space>
              <Form.Item name="captcha" rules={[{ required: true, message: '请输入验证码' }]}>
                <Input prefix={<SafetyOutlined className="site-form-item-icon" />} size="large" placeholder="验证码" />
              </Form.Item>
              <div>
                <Image width={120} height={40} margin-top={-10} src={captchaUrl} preview={false} onClick={getCaptcha} />
              </div>
            </Space>

            {/* <Form.Item name="remember" valuePropName="checked">
              <Checkbox>记住密码</Checkbox>
            </Form.Item> */}
            <Form.Item>
              <Button
                type="primary"
                htmlType="submit"
                size="large"
                loading={user.status === 'loading'}
                className="submit-btn">
                登录
              </Button>
            </Form.Item>
          </Form>
        </LoginFromWarp>
      </LoginContainer>
    </LoginLayout>
  )
}

export default LoginPage

const LoginLayout = styled.div`
  position: relative;
  width: 100%;
  height: 100vh;
  /* background: #000
    url('https://fe-internal-files-1301947356.cos.ap-beijing.myqcloud.com/public/image/background.svg')
    no-repeat 50%; */
`

const LoginContainer = styled.div`
  width: 500px;
  height: 500px;
  box-sizing: border-box;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  margin: auto auto;
  background: transparent;
  padding: 20px;
  .ant-space-align-center {
    align-items: flex-start;
  }
`
const LoginContainerHeader = styled.h1`
  height: 44px;
  line-height: 44px;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;
  margin-bottom: 20px;
  font-size: 32px;
  > img {
    display: block;
    height: 44px;
    margin-bottom: 10px;
  }
  > span {
    color: rgba(0, 0, 0, 0.85);
    font-weight: 600;
  }
`

const LoginFromWarp = styled.div`
  width: 368px;
  margin: 0 auto;
  .icon {
    color: rgba(0, 0, 0, 0.25);
  }
  .submit-btn {
    width: 100%;
    margin-top: 15px;
  }
`
