
import { useState, useEffect, useCallback } from 'react'

import { ModalForm, ProFormDigit, ProFormText, ProFormTreeSelect } from '@ant-design/pro-form'

import { message } from 'antd'

import { GetDetailApi, UpdateApi, AddApi } from '../common/services'

type TProps = {
  visible: boolean,
  id: number,
  handleUpdateVisible: (value:boolean, type: string) => void
}
const AddUpdate = ({ id, visible, handleUpdateVisible }:TProps) => {
  const [title, setTitle] = useState<string>('')
  const files = { // TreeSelect组件配置项
    showArrow: false,
    filterTreeNode: true,
    showSearch: true,
    dropdownMatchSelectWidth: false,
    labelInValue: true,
    autoClearSearchValue: true,
    multiple: true,
    treeNodeFilterProp: 'label',
    fieldNames: {
      label: 'label'
    }
  }

  useEffect(() => {
    getMenus()
    setTitle(() => {
      return id ? '编辑演播室' : '创建演播室'
    })
  }, [visible])
  const fetchDetail = useCallback(async () => {
    let data:any = {
      studioName: '', // 演播室名称
      studioId: '', // 演播室id
      ip1: '', // 主服务ip
      ip2: '', // 备服务ip
      port1: '', // 主服务器端口
      port2: '', // 备服务器端口
      sceneNameS: '', // 主场景地址
      sceneNameQ: '', // 备场景地址
      createTime: '', // 创建时间
      updateTime: '', // 修改时间
      type: '', // 弹幕类型
      intervalTime: 3, // 弹幕轮询时间间隔
      bulletChatNums: 0, // 筛选弹幕限制数量
      powerTime: 3 // 发电时刻开启服务时，默认时间间隔
    }
    if (id) {
      try {
        const res = await GetDetailApi(id)
        if (res.status !== 200) return
        data = res?.data
      } catch (error) {
        console.log(error)
      }
    }
    return data
  }, [id])
  const getMenus = async () => { // 获取所有业务模块
    return [
      {
        label: 'Node1',
        value: '0-0'
      },
      {
        label: 'Node2',
        value: '0-1'
      }
    ]
  }
  const getStudios = async () => { // 获取所有业务模块
    return [
      {
        label: 'Node1',
        value: '0-0'
      },
      {
        label: 'Node2',
        value: '0-1'
      }
    ]
  }
  const cnacelClick = () => {
    handleUpdateVisible(false, '')
  }
  const okClick = async (values:any) => {
    console.log(values, 9999)

    const params:any = {}
    try {
      if (id) {
        params.id = id
      }
      console.log('params===>', params)
      const { status } = id ? await UpdateApi(params) : await AddApi(params)
      if (status === 200) {
        id ? message.success('编辑成功') : message.success('创建成功')
        handleUpdateVisible(false, 'add')
      }
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <ModalForm
    title={title}
    visible={visible}
    autoFocusFirstInput
    modalProps={{
      onCancel: cnacelClick,
      destroyOnClose: true
    }}
    onFinish={async (e) => {
      okClick(e)
    }}
    request={fetchDetail}>
      <ProFormText width="md" name="studioName" label="赛事名称" placeholder="请输入演播室名称" />
      <ProFormDigit width="md" name="studioId" label="赛事说明" placeholder="请输入演播室id" />
      <ProFormTreeSelect
        name="studio"
        label="关联演播室"
        placeholder="请选择演播室"
        allowClear
        width="lg"
        secondary
        request={getStudios}
        fieldProps={files}
      />
      <ProFormTreeSelect
        name="name"
        label="关联互动模块"
        placeholder="请选择互动模块"
        allowClear
        width="lg"
        secondary
        request={getMenus}
        fieldProps={files}
      />
    </ModalForm>
  )
}
export default AddUpdate
