import React, { lazy } from 'react'
import { Navigate, useRoutes } from 'react-router-dom'

import BaseLayout from '@/layouts/BaseLayout'
import AccountRouter from '@/pages/Account/common/router'
import Login from '@/pages/Login'
import MatchRouter from '@/pages/Match/common/router'
import StudioRouter from '@/pages/Studio/common/router'

import { RouteObject } from './interface'

const Home = lazy(() => import('@/pages/Home/index'))

export const rootRouter: RouteObject[] = [
  {
    path: '/',
    element: <Navigate to="/home" />
  },
  {
    element: <BaseLayout />,
    children: [
      {
        path: '/home',
        name: '首页',
        element: <Home />,
        meta: {
          requiresAuth: true,
          title: '首页',
          key: 'home'
        }
      },
      ...AccountRouter,
      ...StudioRouter,
      ...MatchRouter
    ]
  },
  {
    path: '/login',
    element: <Login />,
    meta: {
      requiresAuth: false,
      title: '登录页',
      key: 'login'
    }
  }
  // 异常页面
  // { path: '*',  element: <Pack /> }
]
const Routes = () => {
  const routes = useRoutes(rootRouter)
  return routes
}
export default Routes
