import { createSlice } from '@reduxjs/toolkit'

export interface BreadcrumbState {
  breadcrumbList: {
    [key: string]: any
  }
}
const initialState: BreadcrumbState = {
  breadcrumbList: {}
}

export const { reducer: breadcrumbReducer, actions } = createSlice({
  name: 'account',
  initialState,
  reducers: {
    setBreadcrumbList: (state, { payload }: { payload: Record<string, any> }) => {
      console.log('[ setBreadcrumbList ]', payload)
      state.breadcrumbList = payload
    }
  },
  extraReducers: {}
})
export const { setBreadcrumbList } = actions

export default breadcrumbReducer
