import axios, { Method, AxiosRequestConfig } from 'axios'

import { message } from 'antd'

import { store } from '@/store'

export type TResult<T = any> = Promise<{code:number, data:T, msg:string}>;
const request = axios.create({
  baseURL: process.env.API_HOST,
  headers: { 'Content-Type': 'application/json' },
  withCredentials: false
})

request.interceptors.request.use(
  (config) => {
    const _config = Object.assign({}, config)
    // newConfig.headers.token = TOKEN;
    // console.log(store.reducer);
    // if (store.state.user.userList[0]) {
    //   newConfig.headers.Authentication = store.state.user.userList[0].token;
    // }
    // if (store.getters.token) {
    //   newConfig.headers.content = 'application/json;charset=UTF-8';
    // }

    // const { data } = newConfig;

    // data.platform = TOKEN;
    return _config
  },
  (error) => {
    return Promise.reject(error)
  }
)

request.interceptors.response.use(
  (res: any) => {
    // console.log('res===>', res)

    const { status, msg } = res.data || {}
    switch (status) {
      case 200:
        return res.data
      case 10020:
      case 10021:
        window.location.href = '/login' // react 路由组件跳转需要使用hooks方式，所以写成原生跳转
      default:
        message.error(msg || '服务器错误')
        return Promise.reject(res)
    }
  },
  (err) => {
    switch (err?.response?.status) {
      case 400:
        break
      case 401:
        break
      case 405:
      case 500:
      default:
        break
    }
    return Promise.reject(err.response)
  }
)

interface RequestOptions extends Partial<AxiosRequestConfig> {
  isAuth?: boolean;
  urlFields?: string[];
  isForm?: boolean;
  transformParams?: (params: any) => any;
}
const createMethod =
  (method: Method = 'get') =>
    (url: string, options?: RequestOptions) => {
      const {
        urlFields,
        isAuth = true,
        isForm = false,
        headers = {},
        transformParams,
        params,
        ...args
      } = options || {}

      let data = ['get'].includes(method) ? { params } : { data: params }
      // : { data: Qs.stringify(params, { arrayFormat: "brackets" }) };

      // 处理formdata形式
      if (isForm) {
        const formParams = new FormData()
        for (const key in params) {
          formParams.append(key, params[key])
        }
        data.data = formParams;
        (options as any).headers = Object.assign({}, options?.headers, {
          'Content-Type': 'multipart/form-data'
        })
      }
      if (typeof transformParams === 'function') {
        data = transformParams(params)
      }
      // 过滤URl参数
      if (urlFields) {
        for (const key of urlFields) {
          url = url.replace(new RegExp(`:${key}`), (params as any)[key])
        }
      }
      // 接口增加权限token
      if (isAuth) {
        const data:any = store.getState()
        if (data.user) {
          // (headers as any)["token"] = data.user["token"];
          (headers as any).token = store.getState().user.token
        }
      }

      return request(url, {
        method,
        headers,
        ...data,
        ...args
      } as any) as Promise<any>
    }

export const Post = createMethod('post')
export const Get = createMethod('get')
export const Delete = createMethod('delete')
export const Put = createMethod('put')

export default request
