import { useMemo } from 'react'

export const useGetParams = () => {
  const { params } = useMemo(() => {
    const url = window.location.href
    const d: Record<string, string|undefined> = {}
    if (url?.indexOf('?') !== -1) {
      const arr = url.slice(url?.indexOf('?') + 1).split('&')
      arr.forEach(item => {
        const [key, val] = item.split('=') || []
        d[key] = val
      })
    }
    return {
      params: d
    }
  }, [])

  // const [params, setParams] = useState<Record<string, any>>({})
  // useEffect(() => {
  //   const url = window.location.href
  //   const d: Record<string, unknown> = {}
  //   if (url.indexOf('?') !== -1) {
  //     const arr = url.slice(url.indexOf('?') + 1).split('&')

  //     arr.forEach(item => {
  //       const [key, val] = item.split('=') || []
  //       d[key] = val
  //     })
  //   }
  //   setParams(d)
  // }, [])

  return {
    params
  }
}
